/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import hudson.init.InitMilestone;
import hudson.model.Describable;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainerDescriptor;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.DeprecationUtil;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.integrations.PermissionFinder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public interface AuthorizationContainer<T extends Describable<T>>
extends Describable<T> {
    public static final Logger LOGGER = Logger.getLogger(AuthorizationContainer.class.getName());

    @Deprecated
    default public void add(Permission permission, String sid) {
        DeprecationUtil.logDeprecationMessage();
        this.add(permission, new PermissionEntry(AuthorizationType.EITHER, sid));
    }

    default public void add(Permission permission, PermissionEntry entry) {
        if (permission == null) {
            throw new IllegalArgumentException("Permission cannot be null for: " + String.valueOf(entry));
        }
        LOGGER.log(Level.FINE, "Grant permission \"{0}\" to \"{1}\")", new Object[]{permission, entry});
        this.getGrantedPermissionEntries().computeIfAbsent(permission, k -> new HashSet()).add(entry);
        if (entry.getType() != AuthorizationType.USER) {
            this.recordGroup(entry.getSid());
        }
    }

    @Deprecated
    default public Map<Permission, Set<String>> getGrantedPermissions() {
        DeprecationUtil.logDeprecationMessage();
        HashMap<Permission, Set<String>> ret = new HashMap<Permission, Set<String>>();
        Map<Permission, Set<PermissionEntry>> grantedPermissionEntries = this.getGrantedPermissionEntries();
        for (Map.Entry<Permission, Set<PermissionEntry>> entry : grantedPermissionEntries.entrySet()) {
            Set eitherGrants = entry.getValue().stream().filter(it -> it.getType() == AuthorizationType.EITHER).map(PermissionEntry::getSid).collect(Collectors.toSet());
            if (eitherGrants.size() <= 0) continue;
            ret.put(entry.getKey(), eitherGrants);
        }
        return ret;
    }

    public Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries();

    public Set<String> getGroups();

    public void recordGroup(String var1);

    @Restricted(value={NoExternalUse.class})
    default public void add(String shortForm) {
        String sid;
        String permissionString;
        AuthorizationType type;
        int firstEndIndex = shortForm.indexOf(58);
        String first = shortForm.substring(0, firstEndIndex);
        try {
            type = AuthorizationType.valueOf(first);
            int permissionEndIndex = shortForm.indexOf(58, first.length() + 1);
            permissionString = shortForm.substring(firstEndIndex + 1, permissionEndIndex);
            sid = shortForm.substring(permissionEndIndex + 1);
        }
        catch (IllegalArgumentException ex) {
            type = AuthorizationType.EITHER;
            permissionString = first;
            sid = shortForm.substring(firstEndIndex + 1);
            LOGGER.log(Jenkins.get().getInitLevel().ordinal() < InitMilestone.COMPLETED.ordinal() ? Level.WARNING : Level.FINE, "Processing a permission assignment in the legacy format (without explicit TYPE prefix): " + shortForm);
        }
        Permission p = AuthorizationContainer.parsePermission(permissionString);
        if (!p.isContainedBy(((AuthorizationContainerDescriptor)this.getDescriptor()).getPermissionScope())) {
            LOGGER.log(Level.WARNING, "Tried to add inapplicable permission " + String.valueOf(p) + " for " + sid + " in " + String.valueOf(this) + ", skipping");
            return;
        }
        this.add(p, new PermissionEntry(type, sid));
    }

    @Restricted(value={NoExternalUse.class})
    public static Permission parsePermission(String permission) {
        Permission p = Permission.fromId((String)permission);
        if (p == null) {
            p = PermissionFinder.findPermission(permission);
        }
        if (p == null) {
            throw new IllegalArgumentException("Failed to parse '" + permission + "' --- no such permission");
        }
        return p;
    }

    @Restricted(value={NoExternalUse.class})
    public Permission getEditingPermission();

    @Deprecated
    default public List<String> getAllSIDs() {
        DeprecationUtil.logDeprecationMessage();
        TreeSet<String> r = new TreeSet<String>(new IdStrategyComparator());
        for (Set<String> set : this.getGrantedPermissions().values()) {
            r.addAll(set);
        }
        r.remove("anonymous");
        Object[] data = r.toArray(new String[0]);
        Arrays.sort(data);
        return Arrays.asList(data);
    }

    default public List<PermissionEntry> getAllPermissionEntries() {
        TreeSet<PermissionEntry> entries = new TreeSet<PermissionEntry>(new PermissionEntryComparator());
        for (Set<PermissionEntry> s : this.getGrantedPermissionEntries().values()) {
            entries.addAll(s);
        }
        entries.remove(new PermissionEntry(AuthorizationType.USER, "anonymous"));
        return new ArrayList<PermissionEntry>(entries);
    }

    @Deprecated
    default public boolean hasPermission(String sid, Permission p) {
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        IdStrategy groupIdStrategy = securityRealm.getGroupIdStrategy();
        IdStrategy userIdStrategy = securityRealm.getUserIdStrategy();
        while (p != null) {
            Set<String> set;
            if (p.getEnabled() && (set = this.getGrantedPermissions().get(p)) != null) {
                if (set.contains(sid)) {
                    return true;
                }
                for (String s : set) {
                    if (!userIdStrategy.equals(s, sid) && !groupIdStrategy.equals(s, sid)) continue;
                    return true;
                }
            }
            p = p.impliedBy;
        }
        return false;
    }

    default public boolean hasPermission(String sid, Permission p, boolean principal) {
        IdStrategy strategy;
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        IdStrategy idStrategy = strategy = principal ? securityRealm.getUserIdStrategy() : securityRealm.getGroupIdStrategy();
        while (p != null) {
            Set<PermissionEntry> set;
            if (p.getEnabled() && (set = this.getGrantedPermissionEntries().get(p)) != null) {
                if (set.contains(new PermissionEntry(AuthorizationType.EITHER, sid))) {
                    return true;
                }
                if (set.contains(new PermissionEntry(principal ? AuthorizationType.USER : AuthorizationType.GROUP, sid))) {
                    return true;
                }
                for (PermissionEntry entry : set) {
                    if (!entry.isApplicable(principal) || !strategy.equals(entry.getSid(), sid)) continue;
                    return true;
                }
            }
            p = p.impliedBy;
        }
        return false;
    }

    @Deprecated
    default public boolean hasExplicitPermission(String sid, Permission p) {
        DeprecationUtil.logDeprecationMessage();
        for (AuthorizationType type : AuthorizationType.values()) {
            if (!this.hasExplicitPermission(new PermissionEntry(type, sid), p)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasExplicitPermission(PermissionEntry entry, Permission p) {
        if (entry == null) {
            return false;
        }
        Set<PermissionEntry> grantedEntries = this.getGrantedPermissionEntries().get(p);
        if (grantedEntries != null && p.getEnabled()) {
            if (grantedEntries.contains(entry)) {
                return true;
            }
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            IdStrategy groupIdStrategy = securityRealm.getGroupIdStrategy();
            IdStrategy userIdStrategy = securityRealm.getUserIdStrategy();
            for (PermissionEntry s : grantedEntries) {
                if (s.getType() != entry.getType() || !userIdStrategy.equals(s.getSid(), entry.getSid()) && !groupIdStrategy.equals(s.getSid(), entry.getSid())) continue;
                return true;
            }
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public static class IdStrategyComparator
    implements Comparator<String> {
        private final SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        private final IdStrategy groupIdStrategy = this.securityRealm.getGroupIdStrategy();
        private final IdStrategy userIdStrategy = this.securityRealm.getUserIdStrategy();

        @Override
        public int compare(String o1, String o2) {
            int r = this.userIdStrategy.compare(o1, o2);
            if (r == 0) {
                r = this.groupIdStrategy.compare(o1, o2);
            }
            return r;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class PermissionEntryComparator
    implements Comparator<PermissionEntry> {
        private final SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        private final IdStrategy groupIdStrategy = this.securityRealm.getGroupIdStrategy();
        private final IdStrategy userIdStrategy = this.securityRealm.getUserIdStrategy();
        private final IdStrategyComparator eitherComparator = new IdStrategyComparator();

        @Override
        public int compare(PermissionEntry o1, PermissionEntry o2) {
            int r = o1.getType().compareTo(o2.getType());
            if (r != 0) {
                return r;
            }
            switch (o1.getType()) {
                case USER: {
                    return this.userIdStrategy.compare(o1.getSid(), o2.getSid());
                }
                case GROUP: {
                    return this.groupIdStrategy.compare(o1.getSid(), o2.getSid());
                }
                case EITHER: {
                    return this.eitherComparator.compare(o1.getSid(), o2.getSid());
                }
            }
            throw new IllegalArgumentException("Unexpected arguments o1: " + String.valueOf(o1) + ", o2: " + String.valueOf(o2));
        }
    }
}

