/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.matomoanalytics;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.PageDecorator;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class MatomoPageDecorator
extends PageDecorator {
    public static final String PLUGIN_DISPLAY_NAME = "Matomo Analytics";
    private String matomoSiteID;
    private String matomoServer;
    private String matomoPath;
    private String matomoPhp;
    private String matomoJs;
    private boolean matomoUseHttps = true;
    private boolean matomoSendUserID = false;

    public MatomoPageDecorator() {
        this.load();
    }

    @DataBoundConstructor
    public MatomoPageDecorator(String matomoSiteID, String matomoServer, String matomoPath, String matomoPhp, String matomoJs, boolean matomoUseHttps, boolean matomoSendUserID) {
        this();
        this.setMatomoSiteID(matomoSiteID);
        this.setMatomoServer(matomoServer);
        this.setMatomoPath(matomoPath);
        this.setMatomoPhp(matomoPhp);
        this.setMatomoJs(matomoJs);
        this.setMatomoUseHttps(matomoUseHttps);
        this.setMatomoSendUserID(matomoSendUserID);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public String getMatomoSiteID() {
        return this.matomoSiteID;
    }

    public void setMatomoSiteID(String matomoSiteID) {
        this.matomoSiteID = matomoSiteID;
    }

    public String getMatomoServer() {
        return this.matomoServer;
    }

    public void setMatomoServer(String matomoServer) {
        this.matomoServer = matomoServer;
    }

    public String getMatomoPath() {
        return this.matomoPath;
    }

    public void setMatomoPath(String matomoPath) {
        this.matomoPath = matomoPath;
    }

    public String getMatomoPhp() {
        return this.matomoPhp;
    }

    public void setMatomoPhp(String matomoPhp) {
        this.matomoPhp = matomoPhp;
    }

    public String getMatomoJs() {
        return this.matomoJs;
    }

    public void setMatomoJs(String matomoJs) {
        this.matomoJs = matomoJs;
    }

    public boolean isMatomoUseHttps() {
        return this.matomoUseHttps;
    }

    public void setMatomoUseHttps(boolean matomoUseHttps) {
        this.matomoUseHttps = matomoUseHttps;
    }

    public boolean isMatomoSendUserID() {
        return this.matomoSendUserID;
    }

    public void setMatomoSendUserID(boolean matomoSendUserID) {
        this.matomoSendUserID = matomoSendUserID;
    }

    public String getProtocolString() {
        if (this.matomoUseHttps) {
            return "https://";
        }
        return "http://";
    }
}

