/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.utilities;

import com.mathworks.ci.MatlabExecutionException;
import com.mathworks.ci.Utilities;
import com.mathworks.ci.parameters.MatlabActionParameters;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.slaves.WorkspaceList;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;

public class MatlabCommandRunner {
    private MatlabActionParameters params;
    private FilePath tempFolder;
    private OutputStream stdOut;
    private Map<String, String> additionalEnvVars;

    public MatlabCommandRunner(MatlabActionParameters params) throws IOException, InterruptedException {
        FilePath tmpRoot;
        this.params = params;
        this.additionalEnvVars = new HashMap<String, String>();
        FilePath workspace = params.getWorkspace();
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace cannot be null");
        }
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        if ((tmpRoot = WorkspaceList.tempDir((FilePath)workspace)) == null) {
            throw new IOException("Unable to create temporary directory in workspace.");
        }
        tmpRoot.mkdirs();
        this.tempFolder = tmpRoot.createTempDir("matlab", null);
        if (this.tempFolder == null) {
            throw new IOException("Failed to create a temporary MATLAB directory");
        }
    }

    public void runMatlabCommand(String command) throws IOException, InterruptedException, MatlabExecutionException {
        this.params.getTaskListener().getLogger().println("\n#################### Starting command output ####################");
        FilePath exePath = this.prepareRunnerExecutable();
        FilePath scriptFile = this.createFileWithContent(command);
        String cmd = "setenv('MW_ORIG_WORKING_FOLDER', cd('" + this.tempFolder.getRemote() + "'));" + scriptFile.getBaseName();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(exePath.getRemote());
        args.add(cmd);
        args.add(this.params.getStartupOptions().split(" "));
        EnvVars env = this.getEnvVars();
        Utilities.addMatlabToEnvPathFromAxis(Computer.currentComputer(), this.params.getTaskListener(), env);
        Launcher.ProcStarter proc = this.params.getLauncher().launch().envs((Map)env).cmds(args);
        if (this.stdOut == null) {
            proc.stdout(this.params.getTaskListener());
        } else {
            proc.stdout(this.stdOut);
        }
        proc.pwd(this.params.getWorkspace());
        int code = proc.join();
        if (code != 0) {
            throw new MatlabExecutionException(code);
        }
    }

    public void redirectStdOut(OutputStream out) {
        this.stdOut = out;
    }

    public void addEnvironmentVariable(String key, String value) {
        this.additionalEnvVars.put(key, value);
    }

    public EnvVars getEnvVars() {
        EnvVars env = new EnvVars(this.params.getEnvVars());
        env.putAll(this.additionalEnvVars);
        return env;
    }

    public FilePath copyFileToTempFolder(String sourceFile, String targetFile) throws IOException, InterruptedException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        FilePath targetFilePath = new FilePath(this.tempFolder, targetFile);
        InputStream in = classLoader.getResourceAsStream(sourceFile);
        targetFilePath.copyFrom(in);
        targetFilePath.chmod(493);
        return targetFilePath;
    }

    public FilePath getTempFolder() {
        return this.tempFolder;
    }

    public void removeTempFolder() throws IOException, InterruptedException {
        if (this.tempFolder.exists()) {
            this.tempFolder.deleteRecursive();
        }
    }

    protected FilePath createFileWithContent(String content) throws IOException, InterruptedException {
        String fileName = "script_" + RandomStringUtils.randomAlphanumeric((int)8) + ".m";
        FilePath scriptFile = new FilePath(this.tempFolder, fileName);
        String expandedContent = this.getEnvVars().expand(content);
        String finalContent = "cd(getenv('MW_ORIG_WORKING_FOLDER'));\n" + expandedContent;
        this.params.getTaskListener().getLogger().println("Generating MATLAB script with content:\n" + expandedContent + "\n\n");
        scriptFile.write(finalContent, "UTF-8");
        return scriptFile;
    }

    protected FilePath prepareRunnerExecutable() throws IOException, InterruptedException {
        Launcher launcher = this.params.getLauncher();
        if (launcher.isUnix()) {
            ByteArrayOutputStream kernelStream = new ByteArrayOutputStream();
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add("uname");
            args.add("-s");
            args.add("-m");
            launcher.launch().cmds(args).masks(new boolean[]{true, true, true}).stdout((OutputStream)kernelStream).join();
            String kernelArch = kernelStream.toString("UTF-8");
            String runnerSource = kernelArch.contains("Linux") ? "glnxa64/run-matlab-command" : (kernelArch.contains("arm64") ? "maca64/run-matlab-command" : "maci64/run-matlab-command");
            String dest = "run-matlab-command";
            this.copyFileToTempFolder(runnerSource, dest);
            return new FilePath(this.tempFolder, dest);
        }
        String dest = "run-matlab-command.exe";
        this.copyFileToTempFolder("win64/run-matlab-command.exe", dest);
        return new FilePath(this.tempFolder, dest);
    }
}

