/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.freestyle;

import com.mathworks.ci.Message;
import com.mathworks.ci.actions.MatlabActionFactory;
import com.mathworks.ci.actions.RunMatlabTestsAction;
import com.mathworks.ci.freestyle.options.SelectByFolder;
import com.mathworks.ci.freestyle.options.SourceFolder;
import com.mathworks.ci.freestyle.options.SourceFolderPaths;
import com.mathworks.ci.freestyle.options.StartupOptions;
import com.mathworks.ci.freestyle.options.TestFolders;
import com.mathworks.ci.parameters.TestActionParameters;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabTestsBuilder
extends Builder
implements SimpleBuildStep {
    private transient int buildResult;
    private transient boolean tapChkBx;
    private transient boolean junitChkBx;
    private transient boolean coberturaChkBx;
    private transient boolean stmResultsChkBx;
    private transient boolean modelCoverageChkBx;
    private transient boolean pdfReportChkBx;
    private Artifact tapArtifact = new NullArtifact();
    private Artifact junitArtifact = new NullArtifact();
    private Artifact coberturaArtifact = new NullArtifact();
    private Artifact stmResultsArtifact = new NullArtifact();
    private Artifact modelCoverageArtifact = new NullArtifact();
    private Artifact pdfReportArtifact = new NullArtifact();
    private SourceFolder sourceFolder;
    private SelectByFolder selectByFolder;
    private SelectByTag selectByTag;
    private StartupOptions startupOptions;
    private String loggingLevel = "default";
    private String outputDetail = "default";
    private boolean useParallel = false;
    private boolean strict = false;
    private MatlabActionFactory factory;

    public RunMatlabTestsBuilder(MatlabActionFactory factory) {
        this.factory = factory;
    }

    @DataBoundConstructor
    public RunMatlabTestsBuilder() {
        this(new MatlabActionFactory());
    }

    @DataBoundSetter
    public void setTapArtifact(TapArtifact tapArtifact) {
        this.tapArtifact = tapArtifact;
    }

    @DataBoundSetter
    public void setJunitArtifact(JunitArtifact junitArtifact) {
        this.junitArtifact = junitArtifact;
    }

    @DataBoundSetter
    public void setCoberturaArtifact(CoberturaArtifact coberturaArtifact) {
        this.coberturaArtifact = coberturaArtifact;
    }

    @DataBoundSetter
    public void setStmResultsArtifact(StmResultsArtifact stmResultsArtifact) {
        this.stmResultsArtifact = stmResultsArtifact;
    }

    @DataBoundSetter
    public void setModelCoverageArtifact(ModelCovArtifact modelCoverageArtifact) {
        this.modelCoverageArtifact = modelCoverageArtifact;
    }

    @DataBoundSetter
    public void setPdfReportArtifact(PdfArtifact pdfReportArtifact) {
        this.pdfReportArtifact = pdfReportArtifact;
    }

    @DataBoundSetter
    public void setSelectByTag(SelectByTag selectByTag) {
        this.selectByTag = selectByTag;
    }

    @DataBoundSetter
    public void setSourceFolder(SourceFolder sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @DataBoundSetter
    public void setSelectByFolder(SelectByFolder selectByFolder) {
        this.selectByFolder = selectByFolder;
    }

    @DataBoundSetter
    public void setStartupOptions(StartupOptions startupOptions) {
        this.startupOptions = startupOptions;
    }

    @DataBoundSetter
    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    @DataBoundSetter
    public void setOutputDetail(String outputDetail) {
        this.outputDetail = outputDetail;
    }

    @DataBoundSetter
    public void setUseParallel(boolean useParallel) {
        this.useParallel = useParallel;
    }

    @DataBoundSetter
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String getTapReportFilePath() {
        return this.getTapArtifact().getFilePath();
    }

    public Artifact getTapArtifact() {
        return this.tapArtifact;
    }

    public Artifact getJunitArtifact() {
        return this.junitArtifact;
    }

    public String getJunitReportFilePath() {
        return this.getJunitArtifact().getFilePath();
    }

    public Artifact getCoberturaArtifact() {
        return this.coberturaArtifact;
    }

    public String getCoberturaReportFilePath() {
        return this.getCoberturaArtifact().getFilePath();
    }

    public Artifact getStmResultsArtifact() {
        return this.stmResultsArtifact;
    }

    public String getStmResultsFilePath() {
        return this.getStmResultsArtifact().getFilePath();
    }

    public Artifact getModelCoverageArtifact() {
        return this.modelCoverageArtifact;
    }

    public String getModelCoverageFilePath() {
        return this.getModelCoverageArtifact().getFilePath();
    }

    public Artifact getPdfReportArtifact() {
        return this.pdfReportArtifact;
    }

    public String getPdfReportFilePath() {
        return this.getPdfReportArtifact().getFilePath();
    }

    public SelectByTag getSelectByTag() {
        return this.selectByTag;
    }

    public String getSelectByTagAsString() {
        return this.selectByTag == null ? null : this.selectByTag.getTestTag();
    }

    public SourceFolder getSourceFolder() {
        return this.sourceFolder;
    }

    public List<String> getSourceFolderPaths() {
        return this.sourceFolder == null ? null : this.sourceFolder.getSourceFolderStringPaths();
    }

    public SelectByFolder getSelectByFolder() {
        return this.selectByFolder;
    }

    public List<String> getSelectByFolderPaths() {
        return this.selectByFolder == null ? null : this.selectByFolder.getTestFolderStringPaths();
    }

    private Artifact getArtifactObject(boolean isChecked, Artifact returnVal) {
        return isChecked ? returnVal : new NullArtifact();
    }

    public String getLoggingLevel() {
        return this.loggingLevel == null ? "default" : this.loggingLevel;
    }

    public String getOutputDetail() {
        return this.outputDetail == null ? "default" : this.outputDetail;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public boolean getUseParallel() {
        return this.useParallel;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public String getStartupOptionsAsString() {
        return this.startupOptions == null ? "" : this.startupOptions.getOptions();
    }

    protected Object readResolve() {
        this.pdfReportArtifact = Optional.ofNullable(this.pdfReportArtifact).orElseGet(() -> this.getArtifactObject(this.pdfReportChkBx, new PdfArtifact("matlabTestArtifacts/testreport.pdf")));
        this.tapArtifact = Optional.ofNullable(this.tapArtifact).orElseGet(() -> this.getArtifactObject(this.tapChkBx, new TapArtifact("matlabTestArtifacts/taptestresults.tap")));
        this.junitArtifact = Optional.ofNullable(this.junitArtifact).orElseGet(() -> this.getArtifactObject(this.junitChkBx, new JunitArtifact("matlabTestArtifacts/junittestresults.xml")));
        this.coberturaArtifact = Optional.ofNullable(this.coberturaArtifact).orElseGet(() -> this.getArtifactObject(this.coberturaChkBx, new CoberturaArtifact("matlabTestArtifacts/cobertura.xml")));
        this.stmResultsArtifact = Optional.ofNullable(this.stmResultsArtifact).orElseGet(() -> this.getArtifactObject(this.stmResultsChkBx, new StmResultsArtifact("matlabTestArtifacts/simulinktestresults.mldatx")));
        this.modelCoverageArtifact = Optional.ofNullable(this.modelCoverageArtifact).orElseGet(() -> this.getArtifactObject(this.modelCoverageChkBx, new ModelCovArtifact("matlabTestArtifacts/coberturamodelcoverage.xml")));
        if (this.factory == null) {
            this.factory = new MatlabActionFactory();
        }
        return this;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment(listener);
        TestActionParameters params = new TestActionParameters(build, workspace, env, launcher, listener, this.getStartupOptionsAsString(), this.getPdfReportFilePath(), this.getTapReportFilePath(), this.getJunitReportFilePath(), this.getCoberturaReportFilePath(), this.getStmResultsFilePath(), this.getModelCoverageFilePath(), this.getSelectByTagAsString(), this.getLoggingLevel(), this.getOutputDetail(), this.getUseParallel(), this.getStrict(), this.getSourceFolderPaths(), this.getSelectByFolderPaths());
        RunMatlabTestsAction action = this.factory.createAction(params);
        try {
            action.run();
        }
        catch (Exception e) {
            build.setResult(Result.FAILURE);
        }
    }

    public static class NullArtifact
    implements Artifact {
        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
        }

        @Override
        public boolean getSelected() {
            return false;
        }

        @Override
        public String getFilePath() {
            return null;
        }
    }

    public static interface Artifact {
        public void addFilePathArgTo(Map<String, String> var1);

        public String getFilePath();

        public boolean getSelected();
    }

    public static final class SelectByTag
    extends AbstractDescribableImpl<SelectByTag> {
        private String testTag;
        private static final String SELECT_BY_TAG = "SelectByTag";

        @DataBoundConstructor
        public SelectByTag(String testTag) {
            this.testTag = Util.fixNull((String)testTag);
        }

        public String getTestTag() {
            return this.testTag;
        }

        public void addTagToInputArgs(List<String> inputArgsList) {
            inputArgsList.add("'SelectByTag','" + this.getTestTag().replaceAll("'", "''") + "'");
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<SelectByTag> {
        }
    }

    public static class ModelCovArtifact
    extends AbstractArtifactImpl {
        private static final String COBERTURA_MODEL_COVERAGE = "CoberturaModelCoverage";

        @DataBoundConstructor
        public ModelCovArtifact(String modelCoverageFilePath) {
            super(modelCoverageFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(COBERTURA_MODEL_COVERAGE, this.getFilePath());
        }
    }

    public static class StmResultsArtifact
    extends AbstractArtifactImpl {
        private static final String STM_RESULTS = "SimulinkTestResults";

        @DataBoundConstructor
        public StmResultsArtifact(String stmResultsFilePath) {
            super(stmResultsFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(STM_RESULTS, this.getFilePath());
        }
    }

    public static class CoberturaArtifact
    extends AbstractArtifactImpl {
        private static final String COBERTURA_CODE_COVERAGE = "CoberturaCodeCoverage";

        @DataBoundConstructor
        public CoberturaArtifact(String coberturaReportFilePath) {
            super(coberturaReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(COBERTURA_CODE_COVERAGE, this.getFilePath());
        }
    }

    public static class JunitArtifact
    extends AbstractArtifactImpl {
        private static final String JUNIT_TEST_RESULTS = "JUnitTestResults";

        @DataBoundConstructor
        public JunitArtifact(String junitReportFilePath) {
            super(junitReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(JUNIT_TEST_RESULTS, this.getFilePath());
        }
    }

    public static class TapArtifact
    extends AbstractArtifactImpl {
        private static final String TAP_TEST_RESULTS = "TAPTestResults";

        @DataBoundConstructor
        public TapArtifact(String tapReportFilePath) {
            super(tapReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(TAP_TEST_RESULTS, this.getFilePath());
        }
    }

    public static class PdfArtifact
    extends AbstractArtifactImpl {
        private static final String PDF_TEST_REPORT = "PDFTestReport";

        @DataBoundConstructor
        public PdfArtifact(String pdfReportFilePath) {
            super(pdfReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(PDF_TEST_REPORT, this.getFilePath());
        }
    }

    public static abstract class AbstractArtifactImpl
    implements Artifact {
        private String filePath;

        protected AbstractArtifactImpl(String path) {
            this.filePath = path;
        }

        @Override
        public boolean getSelected() {
            return true;
        }

        public void setFilePath(String path) {
            this.filePath = path;
        }

        @Override
        public String getFilePath() {
            return this.filePath;
        }
    }

    @Extension
    public static class RunMatlabTestsDescriptor
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder", RunMatlabTestsBuilder.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.SourceFolderPaths", SourceFolderPaths.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.TestFolders", TestFolders.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder$PdfArtifact", PdfArtifact.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder$JunitArtifact", JunitArtifact.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder$TapArtifact", TapArtifact.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder$CoberturaArtifact", CoberturaArtifact.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder$StmResultsArtifact", StmResultsArtifact.class);
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabTestsBuilder$ModelCovArtifact", ModelCovArtifact.class);
        }

        public String getDisplayName() {
            return Message.getBuilderDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public ListBoxModel doFillLoggingLevelItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Default", "default");
            items.add("None", "none");
            items.add("Terse", "terse");
            items.add("Concise", "concise");
            items.add("Detailed", "detailed");
            items.add("Verbose", "verbose");
            return items;
        }

        public ListBoxModel doFillOutputDetailItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Default", "default");
            items.add("None", "none");
            items.add("Terse", "terse");
            items.add("Concise", "concise");
            items.add("Detailed", "detailed");
            items.add("Verbose", "verbose");
            return items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }
    }
}

