/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabInstallation;
import com.mathworks.ci.MatlabNotFoundError;
import com.mathworks.ci.Message;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Utilities {
    public static String getCellArrayFromList(List<String> listOfStr) {
        Predicate<String> isEmpty = String::isEmpty;
        Predicate<String> isNotEmpty = isEmpty.negate();
        List filteredListOfStr = listOfStr.stream().filter(isNotEmpty).collect(Collectors.toList());
        filteredListOfStr.replaceAll(val -> "'" + val.replaceAll("'", "''") + "'");
        return "{" + String.join((CharSequence)",", filteredListOfStr) + "}";
    }

    public static void addMatlabToEnvPathFromAxis(Computer cmp, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        String name = (String)env.get((Object)Message.getValue("Axis.matlab.key"));
        if (name == null || name.isEmpty() || env.get((Object)"matlabroot") != null) {
            return;
        }
        FilePath matlabRoot = Utilities.getNodeSpecificHome(name, cmp.getNode(), listener, env);
        FilePath matlabBin = new FilePath(matlabRoot, "bin");
        env.put("PATH+matlabroot", matlabBin.getRemote());
        listener.getLogger().println("\n" + String.format(Message.getValue("matlab.added.to.path.from"), matlabBin.getRemote()) + "\n");
    }

    public static FilePath getNodeSpecificHome(String instName, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        MatlabInstallation inst = MatlabInstallation.getInstallation(instName);
        if (inst == null || node == null) {
            throw new MatlabNotFoundError("MATLAB installations could not be found");
        }
        FilePath matlabExecutablePath = node.createPath((inst = inst.forNode(node, listener).forEnvironment(env)).getHome());
        if (matlabExecutablePath == null || !matlabExecutablePath.exists()) {
            throw new MatlabNotFoundError(String.format(Message.getValue("matlab.not.found.error.for.node"), instName, Objects.requireNonNull(node).getDisplayName()));
        }
        return matlabExecutablePath;
    }
}

