/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabTestCase;
import com.mathworks.ci.MatlabTestDiagnostics;
import com.mathworks.ci.MatlabTestFile;
import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.model.RunAction2;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TestResultsViewAction
implements RunAction2 {
    private transient Run<?, ?> build;
    private FilePath workspace;
    private String actionID;
    private int totalCount;
    private int passedCount;
    private int failedCount;
    private int incompleteCount;
    private int notRunCount;

    public TestResultsViewAction(Run<?, ?> build, FilePath workspace, String actionID) throws InterruptedException, IOException {
        this.build = build;
        this.workspace = workspace;
        this.actionID = actionID;
        this.totalCount = 0;
        this.passedCount = 0;
        this.failedCount = 0;
        this.incompleteCount = 0;
        this.notRunCount = 0;
        try {
            this.getTestResults();
        }
        catch (IOException | InterruptedException e) {
            throw e;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public List<List<MatlabTestFile>> getTestResults() throws ParseException, InterruptedException, IOException {
        ArrayList<List<MatlabTestFile>> testResults = new ArrayList<List<MatlabTestFile>>();
        FilePath fl = new FilePath(this.build.getRootDir()).child("matlabTestResults" + this.actionID + ".json");
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Paths.get(fl.toURI()), new OpenOption[0]), StandardCharsets.UTF_8);){
            this.totalCount = 0;
            this.passedCount = 0;
            this.failedCount = 0;
            this.incompleteCount = 0;
            this.notRunCount = 0;
            JSONArray testArtifact = (JSONArray)new JSONParser().parse((Reader)reader);
            for (Object jsonTestSessionResults : testArtifact) {
                ArrayList<MatlabTestFile> testSessionResults = new ArrayList<MatlabTestFile>();
                HashMap<String, MatlabTestFile> map = new HashMap<String, MatlabTestFile>();
                if (jsonTestSessionResults instanceof JSONArray) {
                    JSONArray jsonTestSessionResultsArray = (JSONArray)jsonTestSessionResults;
                    for (JSONObject jsonTestCase : jsonTestSessionResultsArray) {
                        this.getTestSessionResults(testSessionResults, jsonTestCase, map);
                    }
                } else if (jsonTestSessionResults instanceof JSONObject) {
                    JSONObject jsonTestCase = (JSONObject)jsonTestSessionResults;
                    this.getTestSessionResults(testSessionResults, jsonTestCase, map);
                }
                testResults.add(testSessionResults);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return testResults;
    }

    private void getTestSessionResults(List<MatlabTestFile> testSessionResults, JSONObject jsonTestCase, Map<String, MatlabTestFile> map) throws IOException, InterruptedException {
        FilePath baseFolder = new FilePath(new File(jsonTestCase.get((Object)"BaseFolder").toString()));
        JSONObject matlabTestCaseResult = (JSONObject)jsonTestCase.get((Object)"TestResult");
        String[] testNameSplit = matlabTestCaseResult.get((Object)"Name").toString().split("/");
        String matlabTestFileName = testNameSplit[0];
        String matlabTestCaseName = testNameSplit[1];
        MatlabTestFile matlabTestFile = map.get(String.valueOf(baseFolder) + File.separator + matlabTestFileName);
        if (matlabTestFile == null) {
            matlabTestFile = new MatlabTestFile(matlabTestFileName);
            map.put(String.valueOf(baseFolder) + File.separator + matlabTestFileName, matlabTestFile);
            testSessionResults.add(matlabTestFile);
        }
        Path baseFolderPath = Paths.get(baseFolder.getRemote(), new String[0]);
        Path workspacePath = Paths.get(this.workspace.getRemote(), new String[0]);
        Path relativePath = workspacePath.relativize(baseFolderPath);
        Path normalizedPath = relativePath.normalize();
        matlabTestFile.setPath(normalizedPath.toString() + File.separator + matlabTestFile.getName());
        MatlabTestCase matlabTestCase = new MatlabTestCase(matlabTestCaseName);
        matlabTestCase.setDuration(new BigDecimal(matlabTestCaseResult.get((Object)"Duration").toString()).setScale(2, RoundingMode.HALF_UP));
        if (((Boolean)matlabTestCaseResult.get((Object)"Failed")).booleanValue()) {
            matlabTestCase.setStatus(TestStatus.FAILED);
        } else if (((Boolean)matlabTestCaseResult.get((Object)"Incomplete")).booleanValue()) {
            matlabTestCase.setStatus(TestStatus.INCOMPLETE);
        } else if (((Boolean)matlabTestCaseResult.get((Object)"Passed")).booleanValue()) {
            matlabTestCase.setStatus(TestStatus.PASSED);
        }
        Object diagnostics = ((JSONObject)matlabTestCaseResult.get((Object)"Details")).get((Object)"DiagnosticRecord");
        if (diagnostics instanceof JSONObject) {
            MatlabTestDiagnostics matlabTestDiagnostics = new MatlabTestDiagnostics();
            matlabTestDiagnostics.setEvent(((JSONObject)diagnostics).get((Object)"Event").toString());
            matlabTestDiagnostics.setReport(((JSONObject)diagnostics).get((Object)"Report").toString());
            matlabTestCase.getDiagnostics().add(matlabTestDiagnostics);
        } else if (diagnostics instanceof JSONArray && ((JSONArray)diagnostics).size() > 0) {
            for (JSONObject diagnosticItem : (JSONArray)diagnostics) {
                MatlabTestDiagnostics matlabTestDiagnostics = new MatlabTestDiagnostics();
                matlabTestDiagnostics.setEvent(diagnosticItem.get((Object)"Event").toString());
                matlabTestDiagnostics.setReport(diagnosticItem.get((Object)"Report").toString());
                matlabTestCase.getDiagnostics().add(matlabTestDiagnostics);
            }
        }
        matlabTestFile.addTestCase(matlabTestCase);
        this.updateStats(matlabTestCase);
    }

    private void updateStats(MatlabTestCase matlabTestCase) {
        ++this.totalCount;
        if (matlabTestCase.getStatus().equals((Object)TestStatus.NOT_RUN)) {
            ++this.notRunCount;
        } else if (matlabTestCase.getStatus().equals((Object)TestStatus.PASSED)) {
            ++this.passedCount;
        } else if (matlabTestCase.getStatus().equals((Object)TestStatus.FAILED)) {
            ++this.failedCount;
        } else if (matlabTestCase.getStatus().equals((Object)TestStatus.INCOMPLETE)) {
            ++this.incompleteCount;
        }
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.onAttached(run);
    }

    public Run getBuild() {
        return this.build;
    }

    @CheckForNull
    public String getDisplayName() {
        return "MATLAB Test Results";
    }

    @CheckForNull
    public String getUrlName() {
        return "matlabTestResults" + this.actionID;
    }

    @CheckForNull
    public String getIconFileName() {
        return "document.png";
    }

    public FilePath getWorkspace() {
        return this.workspace;
    }

    public String getActionID() {
        return this.actionID;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setPassedCount(int passedCount) {
        this.passedCount = passedCount;
    }

    public int getPassedCount() {
        return this.passedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setIncompleteCount(int incompleteCount) {
        this.incompleteCount = incompleteCount;
    }

    public int getIncompleteCount() {
        return this.incompleteCount;
    }

    public void setNotRunCount(int notRunCount) {
        this.notRunCount = notRunCount;
    }

    public int getNotRunCount() {
        return this.notRunCount;
    }

    public static enum TestStatus {
        PASSED,
        FAILED,
        INCOMPLETE,
        NOT_RUN;

    }
}

