/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabTestCase;
import com.mathworks.ci.TestResultsViewAction;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;

public class MatlabTestFile {
    private String path;
    private String name;
    private BigDecimal duration;
    private TestResultsViewAction.TestStatus status;
    private List<MatlabTestCase> matlabTestCases;
    private String id;

    public MatlabTestFile(String name) {
        this.name = name;
        this.path = "";
        this.duration = new BigDecimal("0.0");
        this.status = TestResultsViewAction.TestStatus.NOT_RUN;
        this.matlabTestCases = new ArrayList<MatlabTestCase>();
        this.id = RandomStringUtils.randomAlphanumeric((int)8);
    }

    private void incrementDuration(BigDecimal matlabTestCaseDuration) {
        this.duration = this.duration.add(matlabTestCaseDuration).setScale(2, RoundingMode.HALF_UP);
    }

    private void updateStatus(MatlabTestCase matlabTestCase) {
        if (!this.status.equals((Object)TestResultsViewAction.TestStatus.FAILED)) {
            if (matlabTestCase.getStatus().equals((Object)TestResultsViewAction.TestStatus.FAILED)) {
                this.status = TestResultsViewAction.TestStatus.FAILED;
            } else if (!this.status.equals((Object)TestResultsViewAction.TestStatus.INCOMPLETE)) {
                if (matlabTestCase.getStatus().equals((Object)TestResultsViewAction.TestStatus.INCOMPLETE)) {
                    this.status = TestResultsViewAction.TestStatus.INCOMPLETE;
                } else if (matlabTestCase.getStatus().equals((Object)TestResultsViewAction.TestStatus.PASSED)) {
                    this.status = TestResultsViewAction.TestStatus.PASSED;
                }
            }
        }
    }

    public void addTestCase(MatlabTestCase matlabTestCase) {
        this.incrementDuration(matlabTestCase.getDuration());
        this.updateStatus(matlabTestCase);
        this.getMatlabTestCases().add(matlabTestCase);
    }

    public String getPath() {
        return this.path;
    }

    public String getLinuxStylePath() {
        return this.path.replace('\\', '/');
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getDuration() {
        return this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public TestResultsViewAction.TestStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestResultsViewAction.TestStatus status) {
        this.status = status;
    }

    public List<MatlabTestCase> getMatlabTestCases() {
        return this.matlabTestCases;
    }

    public void setMatlabTestCases(List<MatlabTestCase> matlabTestCases) {
        this.matlabTestCases = matlabTestCases;
    }

    public String getId() {
        return this.id;
    }
}

