/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.BuildArtifactData;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BuildArtifactAction
implements Action {
    private Run<?, ?> build;
    private int totalCount;
    private int skipCount;
    private int failCount;
    private String actionID;
    private static final String ROOT_ELEMENT = "taskDetails";

    public BuildArtifactAction(Run<?, ?> build, String actionID) {
        this.build = build;
        this.actionID = actionID;
        try {
            this.setCounts();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getActionID() {
        return this.actionID == null ? "" : this.actionID;
    }

    @CheckForNull
    public String getIconFileName() {
        return "document.png";
    }

    @CheckForNull
    public String getDisplayName() {
        return "MATLAB Build Results";
    }

    @CheckForNull
    public String getUrlName() {
        return this.actionID == null ? "buildresults" : "buildresults" + this.actionID;
    }

    public List<BuildArtifactData> getBuildArtifact() throws ParseException, InterruptedException, IOException {
        ArrayList<BuildArtifactData> artifactData = new ArrayList<BuildArtifactData>();
        FilePath fl = this.actionID == null ? new FilePath(new File(this.build.getRootDir().getAbsolutePath() + "/buildArtifact.json")) : new FilePath(new File(this.build.getRootDir().getAbsolutePath() + "/buildArtifact" + this.actionID + ".json"));
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(fl.toURI())), "UTF-8");){
            Object obj = new JSONParser().parse((Reader)reader);
            JSONObject jo = (JSONObject)obj;
            if (jo.get((Object)ROOT_ELEMENT) instanceof JSONArray) {
                JSONArray ja = (JSONArray)jo.get((Object)ROOT_ELEMENT);
                Iterator itr2 = ja.iterator();
                while (itr2.hasNext()) {
                    BuildArtifactData data = new BuildArtifactData();
                    for (Map.Entry pair : ((Map)itr2.next()).entrySet()) {
                        this.iterateAllTaskAttributes(pair, data);
                    }
                    artifactData.add(data);
                }
            } else {
                Map ja = (Map)jo.get((Object)ROOT_ELEMENT);
                Iterator itr1 = ja.entrySet().iterator();
                BuildArtifactData data = new BuildArtifactData();
                while (itr1.hasNext()) {
                    Map.Entry pair = itr1.next();
                    this.iterateAllTaskAttributes(pair, data);
                }
                artifactData.add(data);
            }
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return artifactData;
    }

    public void setTotalcount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public Run getOwner() {
        return this.build;
    }

    public void setOwner(Run owner) {
        this.build = owner;
    }

    private void setCounts() throws InterruptedException, ParseException {
        ArrayList<BuildArtifactData> artifactData = new ArrayList<BuildArtifactData>();
        FilePath fl = this.actionID == null ? new FilePath(new File(this.build.getRootDir().getAbsolutePath() + "/buildArtifact.json")) : new FilePath(new File(this.build.getRootDir().getAbsolutePath() + "/buildArtifact" + this.actionID + ".json"));
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(fl.toURI())), "UTF-8");){
            Object obj = new JSONParser().parse((Reader)reader);
            JSONObject jo = (JSONObject)obj;
            if (jo.get((Object)ROOT_ELEMENT) instanceof JSONArray) {
                ja = (JSONArray)jo.get((Object)ROOT_ELEMENT);
                Iterator itr2 = ja.iterator();
                while (itr2.hasNext()) {
                    BuildArtifactData data = new BuildArtifactData();
                    for (Map.Entry pair : ((Map)itr2.next()).entrySet()) {
                        this.iterateFailedSkipped(pair, data);
                    }
                    artifactData.add(data);
                    this.setTotalcount(artifactData.size());
                }
            } else {
                ja = (Map)jo.get((Object)ROOT_ELEMENT);
                Iterator itr1 = ja.entrySet().iterator();
                BuildArtifactData data = new BuildArtifactData();
                while (itr1.hasNext()) {
                    Map.Entry pair = itr1.next();
                    this.iterateFailedSkipped(pair, data);
                }
                artifactData.add(data);
                this.setTotalcount(artifactData.size());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int failCount = 0;
        int skipCount = 0;
        for (BuildArtifactData data : artifactData) {
            if (data.getTaskFailed()) {
                ++failCount;
                continue;
            }
            if (!data.getTaskSkipped()) continue;
            ++skipCount;
        }
        this.setFailCount(failCount);
        this.setSkipCount(skipCount);
    }

    private void iterateAllTaskAttributes(Map.Entry pair, BuildArtifactData data) {
        String key;
        switch (key = pair.getKey().toString()) {
            case "duration": {
                data.setTaskDuration(pair.getValue().toString());
                break;
            }
            case "name": {
                data.setTaskName(pair.getValue().toString());
                break;
            }
            case "description": {
                data.setTaskDescription(pair.getValue().toString());
                break;
            }
            case "failed": {
                data.setTaskFailed((Boolean)pair.getValue());
                break;
            }
            case "skipped": {
                data.setTaskSkipped((Boolean)pair.getValue());
                break;
            }
            case "skipReason": {
                String skipReasonKey;
                data.setSkipReason(switch (skipReasonKey = pair.getValue().toString()) {
                    case "UpToDate" -> "up-to-date";
                    case "UserSpecified", "UserRequested" -> "user requested";
                    case "DependencyFailed" -> "dependency failed";
                    default -> skipReasonKey;
                });
                break;
            }
        }
    }

    private void iterateFailedSkipped(Map.Entry pair, BuildArtifactData data) {
        if (pair.getKey().toString().equalsIgnoreCase("failed")) {
            data.setTaskFailed((Boolean)pair.getValue());
        } else if (pair.getKey().toString().equalsIgnoreCase("skipped")) {
            data.setTaskSkipped((Boolean)pair.getValue());
        }
    }
}

