/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.persistence;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import jenkins.plugins.logstash.persistence.HostBasedLogstashIndexerDao;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class SyslogDao
extends HostBasedLogstashIndexerDao {
    private MessageFormat messageFormat = MessageFormat.RFC_3164;
    private transient UdpSyslogMessageSender messageSender;

    public SyslogDao(String host, int port) {
        this(null, host, port);
    }

    public SyslogDao(UdpSyslogMessageSender udpSyslogMessageSender, String host, int port) {
        super(host, port);
        this.messageSender = udpSyslogMessageSender;
    }

    public void setMessageFormat(MessageFormat format) {
        this.messageFormat = format;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    private synchronized void getMessageSender() {
        if (this.messageSender == null) {
            this.messageSender = new UdpSyslogMessageSender();
        }
    }

    @Override
    public void push(String data) throws IOException {
        data = " @cee: " + (String)data;
        this.getMessageSender();
        this.messageSender.setDefaultMessageHostname(this.getHost());
        this.messageSender.setDefaultAppName("jenkins:");
        this.messageSender.setDefaultFacility(Facility.USER);
        this.messageSender.setDefaultSeverity(Severity.INFORMATIONAL);
        this.messageSender.setSyslogServerHostname(this.getHost());
        this.messageSender.setSyslogServerPort(this.getPort());
        this.messageSender.setMessageFormat(this.messageFormat);
        this.messageSender.sendMessage((CharSequence)data);
    }
}

