/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import hudson.Extension;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.logstash.Messages;
import jenkins.plugins.logstash.persistence.LogstashIndexerDao;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogstashInstallation
extends ToolInstallation {
    private static final long serialVersionUID = -5730780734005293851L;

    @DataBoundConstructor
    public LogstashInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public static Descriptor getLogstashDescriptor() {
        return (Descriptor)Jenkins.getInstance().getDescriptor(LogstashInstallation.class);
    }

    @Extension
    public static final class Descriptor
    extends ToolDescriptor<LogstashInstallation> {
        private transient LogstashIndexerDao.IndexerType type;
        private transient LogstashIndexerDao.SyslogFormat syslogFormat;
        private transient LogstashIndexerDao.SyslogProtocol syslogProtocol;
        private transient String host;
        private transient Integer port = -1;
        private transient String username;
        private transient String password;
        private transient String key;

        public Descriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public LogstashIndexerDao.IndexerType getType() {
            return this.type;
        }

        public LogstashIndexerDao.SyslogFormat getSyslogFormat() {
            return this.syslogFormat;
        }

        public LogstashIndexerDao.SyslogProtocol getSyslogProtocol() {
            return this.syslogProtocol;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getKey() {
            return this.key;
        }
    }
}

