/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.logstash.LogstashConfiguration;
import jenkins.plugins.logstash.LogstashJobProperty;
import jenkins.plugins.logstash.LogstashOutputStream;
import jenkins.plugins.logstash.LogstashWriter;

@Extension(ordinal=1000.0)
public class LogstashConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(LogstashConsoleLogFilter.class.getName());
    private static final long serialVersionUID = 1L;

    public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
        LogstashConfiguration configuration = LogstashConfiguration.getInstance();
        if (!configuration.isEnabled()) {
            LOGGER.log(Level.FINE, "Logstash is disabled. Logs will not be forwarded.");
            return logger;
        }
        if (build != null && build instanceof AbstractBuild) {
            if (this.isLogstashEnabled(build)) {
                LogstashWriter logstash = this.getLogStashWriter(build, logger);
                return new LogstashOutputStream(logger, logstash);
            }
            return logger;
        }
        return logger;
    }

    LogstashWriter getLogStashWriter(Run<?, ?> build, OutputStream errorStream) {
        return new LogstashWriter(build, errorStream, null, build.getCharset());
    }

    private boolean isLogstashEnabled(Run<?, ?> build) {
        AbstractProject project;
        LogstashConfiguration configuration = LogstashConfiguration.getInstance();
        if (configuration.isEnableGlobally()) {
            return true;
        }
        return build.getParent() instanceof AbstractProject && (project = (AbstractProject)build.getParent()).getProperty(LogstashJobProperty.class) != null;
    }
}

