/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.matrix.Combination;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.Map;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.variant.OptionalExtension;

public final class Utils {
    private Utils() {
    }

    @CheckForNull
    public static Job<?, ?> getProject(@NonNull Queue.Item item) {
        if (item.task instanceof Job) {
            return (Job)item.task;
        }
        return null;
    }

    @NonNull
    public static Job<?, ?> getProject(@NonNull Run<?, ?> build) {
        return build.getParent();
    }

    @CheckForNull
    public static LockableResourcesStruct requiredResources(@NonNull Job<?, ?> project) {
        EnvVars env = new EnvVars();
        for (MatrixAssist ma : ExtensionList.lookup(MatrixAssist.class)) {
            env.putAll(ma.getCombination(project));
            project = ma.getMainProject(project);
        }
        RequiredResourcesProperty property = (RequiredResourcesProperty)project.getProperty(RequiredResourcesProperty.class);
        if (property != null) {
            return new LockableResourcesStruct(property, env);
        }
        return null;
    }

    public static interface MatrixAssist {
        @NonNull
        public Map<String, String> getCombination(@NonNull Job<?, ?> var1);

        @NonNull
        public Job<?, ?> getMainProject(@NonNull Job<?, ?> var1);
    }

    @OptionalExtension(requirePlugins={"matrix-project"})
    public static final class MatrixImpl
    implements MatrixAssist {
        @Override
        public Map<String, String> getCombination(Job<?, ?> project) {
            Combination combination;
            if (project instanceof MatrixConfiguration) {
                MatrixConfiguration mc = (MatrixConfiguration)project;
                combination = mc.getCombination();
            } else {
                combination = Map.of();
            }
            return combination;
        }

        @Override
        public Job<?, ?> getMainProject(Job<?, ?> project) {
            MatrixProject matrixProject;
            if (project instanceof MatrixConfiguration) {
                MatrixConfiguration mc = (MatrixConfiguration)project;
                matrixProject = mc.getParent();
            } else {
                matrixProject = project;
            }
            return matrixProject;
        }
    }
}

