/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourceProperty;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.actions.ResourceVariableNameAction;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.Utils;

@Extension
public class LockRunListener
extends RunListener<Run<?, ?>> {
    static final String LOG_PREFIX = "[lockable-resources]";
    static final Logger LOGGER = Logger.getLogger(LockRunListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStarted(Run<?, ?> build, TaskListener listener) {
        if (build.getClass().getName().equals("hudson.matrix.MatrixBuild")) {
            return;
        }
        if (build instanceof AbstractBuild) {
            LockableResourcesManager lrm = LockableResourcesManager.get();
            Object object = LockableResourcesManager.syncResources;
            synchronized (object) {
                Job<?, ?> proj = Utils.getProject(build);
                ArrayList<LockableResource> required = new ArrayList<LockableResource>();
                LockableResourcesStruct resources = Utils.requiredResources(proj);
                if (resources != null) {
                    if (resources.requiredNumber != null || !resources.label.isEmpty() || resources.getResourceMatchScriptText() != null) {
                        required.addAll(lrm.getResourcesFromProject(proj.getFullName()));
                    } else {
                        required.addAll(resources.required);
                    }
                    if (lrm.lock(required, build)) {
                        listener.getLogger().printf("%s acquired lock on %s%n", LOG_PREFIX, required);
                        LOGGER.info(build.getFullDisplayName() + " acquired lock on " + String.valueOf(required));
                        if (resources.requiredVar != null) {
                            ArrayList<StringParameterValue> envsToSet = new ArrayList<StringParameterValue>();
                            envsToSet.add(new StringParameterValue(resources.requiredVar, required.stream().map(LockableResource::getName).collect(Collectors.joining(","))));
                            int index = 0;
                            for (LockableResource lr : required) {
                                String lockEnvName = resources.requiredVar + index;
                                envsToSet.add(new StringParameterValue(lockEnvName, lr.getName()));
                                for (LockableResourceProperty lockProperty : lr.getProperties()) {
                                    String propEnvName = lockEnvName + "_" + lockProperty.getName();
                                    envsToSet.add(new StringParameterValue(propEnvName, lockProperty.getValue()));
                                }
                                ++index;
                            }
                            build.addAction((Action)new ResourceVariableNameAction(envsToSet));
                        }
                    } else {
                        listener.getLogger().printf("%s failed to lock %s%n", LOG_PREFIX, required);
                        LOGGER.warning(build.getFullDisplayName() + " failed to lock " + String.valueOf(required));
                    }
                }
            }
        }
    }

    public void onCompleted(Run<?, ?> build, @NonNull TaskListener listener) {
        if (build.getClass().getName().equals("hudson.matrix.MatrixBuild")) {
            return;
        }
        LOGGER.info(build.getFullDisplayName());
        LockableResourcesManager.get().unlockBuild(build);
    }

    public void onDeleted(Run<?, ?> build) {
        if (build.getClass().getName().equals("hudson.matrix.MatrixBuild")) {
            return;
        }
        LOGGER.info(build.getFullDisplayName());
        LockableResourcesManager.get().unlockBuild(build);
    }
}

