/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown.cli;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownManageLink;
import com.sonymobile.jenkins.plugins.lenientshutdown.cli.LenientQuietDownCommandBase;
import hudson.Extension;
import jenkins.model.Jenkins;

@Extension
public class ToggleLenientQuietDownCommand
extends LenientQuietDownCommandBase {
    public String getShortDescription() {
        ShutdownManageLink management = ShutdownManageLink.getInstance();
        if (management.isGoingToShutdown()) {
            return Messages.CancelShutdownTitle();
        }
        return Messages.ActivateShutdownTitle();
    }

    protected int run() throws Exception {
        ShutdownManageLink management = ShutdownManageLink.getInstance();
        Jenkins.get().checkPermission(management.getRequiredPermission());
        management.performToggleGoingToShutdown();
        this.configure();
        if (management.isGoingToShutdown()) {
            this.stdout.println(Messages.IsAboutToShutDown());
            this.printShutdownConfiguration();
        } else {
            this.stdout.println(Messages.ShutDownCanceled());
        }
        return 0;
    }
}

