/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown.cli;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownConfiguration;
import hudson.Util;
import hudson.cli.CLICommand;
import java.util.Arrays;
import org.kohsuke.args4j.Option;

public abstract class LenientQuietDownCommandBase
extends CLICommand {
    private static final String DELIMETER = ";";
    @Option(name="-m", aliases={"--message"}, usage="The system message to display on every page.", required=false)
    private String message;
    @Option(name="-a", aliases={"--allow-queued"}, usage="Allow all queued items to finish.", required=false)
    private boolean allowAllQueuedItemsOption;
    @Option(name="-w", aliases={"--allow-whitelisted"}, usage="Allow white listed projects to run while queue not empty.", required=false)
    private boolean allowWhiteListedProjectsOption;
    @Option(name="-p", aliases={"--whitelisted-projects"}, usage="A semicolon separated list of white listed projects.", required=false)
    private String whiteListedProjects;

    protected void configure() {
        ShutdownConfiguration config = ShutdownConfiguration.getInstance();
        if (Util.fixEmpty((String)this.message) != null) {
            config.setShutdownMessage(this.message);
            config.save();
        }
        config.setAllowAllQueuedItems(this.allowAllQueuedItemsOption);
        config.setAllowWhiteListedProjects(this.allowWhiteListedProjectsOption);
        if (this.whiteListedProjects != null) {
            config.getWhiteListedProjects().clear();
            config.getWhiteListedProjects().addAll(Arrays.asList(this.whiteListedProjects.split(DELIMETER)));
        }
    }

    protected void printShutdownConfiguration() {
        ShutdownConfiguration config = ShutdownConfiguration.getInstance();
        if (config.isAllowAllQueuedItems()) {
            this.stdout.println(Messages.AllQueuedItemsAllowed());
        } else {
            this.stdout.println(Messages.OnlyUpstreamItemsAllowed());
        }
        if (config.isAllowWhiteListedProjects()) {
            this.stdout.println(Messages.WhiteListedProjectsAllowed());
            this.stdout.println(config.getWhiteListedProjectsText());
        } else {
            this.stdout.println(Messages.WhiteListedProjectsNotAllowed());
        }
    }
}

