/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown.cli;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import com.sonymobile.jenkins.plugins.lenientshutdown.PluginImpl;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Node;
import org.kohsuke.args4j.Argument;

@Extension
public class LenientOnlineNodeCommand
extends CLICommand {
    @Argument(metaVar="NODE", usage="Name of the node", required=true)
    public Node node;

    public String getShortDescription() {
        return Messages.CancelOfflineLeniently();
    }

    protected int run() throws Exception {
        Computer computer = this.node.toComputer();
        if (computer != null) {
            computer.checkPermission(Computer.CONNECT);
            PluginImpl plugin = PluginImpl.getInstance();
            if (plugin.isNodeShuttingDown(this.node.getNodeName())) {
                plugin.toggleNodeShuttingDown(this.node.getNodeName());
                this.stdout.println(Messages.NodeTakenOnline(this.node.getNodeName()));
            } else if (computer.isOffline()) {
                computer.setTemporaryOfflineCause(null);
                this.stdout.println(Messages.NodeTakenOnline(this.node.getNodeName()));
            } else {
                this.stdout.println(Messages.Err_NodeAlreadyOnline(this.node.getNodeName()));
            }
            return 0;
        }
        this.stderr.println("Not a computer: " + this.node.getNodeName());
        return -1;
    }
}

