/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown.cli;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import com.sonymobile.jenkins.plugins.lenientshutdown.PluginImpl;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Node;
import org.kohsuke.args4j.Argument;

@Extension
public class LenientOfflineNodeCommand
extends CLICommand {
    @Argument(metaVar="NODE", usage="Name of the node", required=true)
    public Node node;

    public String getShortDescription() {
        return Messages.TakeOfflineLeniently();
    }

    protected int run() throws Exception {
        Computer computer = this.node.toComputer();
        if (computer != null) {
            computer.checkPermission(Computer.DISCONNECT);
            if (!PluginImpl.getInstance().isNodeShuttingDown(this.node.getNodeName())) {
                PluginImpl.getInstance().setNodeOffline(computer);
                this.stdout.println(Messages.NodeTakenOfflineLeniently(this.node.getNodeName()));
            } else {
                this.stderr.println(Messages.Err_NodeAlreadyShuttingDown(this.node.getNodeName()));
            }
            return 0;
        }
        this.stderr.println("Not a computer: " + this.node.getNodeName());
        return -1;
    }
}

