/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import com.sonymobile.jenkins.plugins.lenientshutdown.PluginImpl;
import hudson.model.Computer;
import hudson.model.RootAction;
import hudson.util.HttpResponses;
import java.io.IOException;
import org.kohsuke.stapler.HttpResponse;

public class ShutdownSlaveAction
implements RootAction {
    public static final String URL = "lenientshutdown";
    public static final String ENABLE_ICON = "symbol-power icon-md";
    public static final String DISABLE_ICON = "symbol-none icon-md";
    private final Computer computer;

    public ShutdownSlaveAction(Computer computer) {
        this.computer = computer;
    }

    public String getIconFileName() {
        String icon = null;
        if (this.computer != null && !PluginImpl.isTemporarilyOffline(this.computer)) {
            PluginImpl plugin = PluginImpl.getInstance();
            if (plugin.isNodeShuttingDown(this.computer.getName()) && this.computer.hasPermission(Computer.CONNECT)) {
                icon = DISABLE_ICON;
            } else if (this.computer.hasPermission(Computer.DISCONNECT)) {
                icon = ENABLE_ICON;
            }
        }
        return icon;
    }

    public String getDisplayName() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin.isNodeShuttingDown(this.computer.getName()) && this.computer.hasPermission(Computer.CONNECT)) {
            return Messages.CancelOfflineLeniently();
        }
        if (this.computer.hasPermission(Computer.DISCONNECT)) {
            return Messages.TakeOfflineLeniently();
        }
        return null;
    }

    public String getUrlName() {
        return URL;
    }

    public HttpResponse doIndex() throws IOException {
        String nodeName;
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin.isNodeShuttingDown(nodeName = this.computer.getName())) {
            this.computer.checkPermission(Computer.CONNECT);
            plugin.toggleNodeShuttingDown(nodeName);
        } else {
            this.computer.checkPermission(Computer.DISCONNECT);
            PluginImpl.getInstance().setNodeOffline(this.computer);
        }
        return HttpResponses.redirectTo((String)"../");
    }
}

