/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.LenientOfflineCause;
import com.sonymobile.jenkins.plugins.lenientshutdown.PluginImpl;
import com.sonymobile.jenkins.plugins.lenientshutdown.QueueUtils;
import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownManageLink;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.slaves.OfflineCause;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;

@Extension(ordinal=1.7976931348623157E308)
public class ShutdownRunListener<R extends Run>
extends RunListener<R> {
    private static final int TASK_DELAY_SECONDS = 10;
    private static final Logger logger = Logger.getLogger(ShutdownRunListener.class.getName());

    public void onCompleted(R r, TaskListener listener) {
        ShutdownManageLink shutdownManageLink;
        boolean isGoingToShutdown;
        Computer computer;
        String nodeName;
        final PluginImpl plugin = PluginImpl.getInstance();
        Executor executor = r.getExecutor();
        if (executor != null && plugin.isNodeShuttingDown(nodeName = (computer = executor.getOwner()).getName()) && !Jenkins.get().isTerminating()) {
            Runnable isNodeIdleTask = new Runnable(){

                @Override
                public void run() {
                    if (plugin.isNodeShuttingDown(nodeName) && !PluginImpl.isTemporarilyOffline(computer) && !QueueUtils.isBuilding(computer) && !QueueUtils.hasNodeExclusiveItemInQueue(computer)) {
                        logger.log(Level.INFO, "Node {0} idle; setting offline since lenient shutdown was active for this node", nodeName);
                        User user = plugin.getOfflineByUser(nodeName);
                        computer.setTemporaryOfflineCause((OfflineCause)new LenientOfflineCause(user));
                    }
                }
            };
            Timer.get().schedule(isNodeIdleTask, 10L, TimeUnit.SECONDS);
        }
        if (isGoingToShutdown = (shutdownManageLink = ShutdownManageLink.getInstance()).isGoingToShutdown()) {
            shutdownManageLink.removeActiveQueueId(r.getQueueId());
        }
    }
}

