/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import com.sonymobile.jenkins.plugins.lenientshutdown.QueueUtils;
import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import jenkins.model.Jenkins;
import jenkins.security.SecurityContextExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class ShutdownManageLink
extends ManagementLink {
    private Set<Long> permittedQueueIds = Collections.synchronizedSet(new HashSet());
    private Set<Long> activeQueueIds = Collections.synchronizedSet(new HashSet());
    private Set<Long> whiteListedQueueIds = Collections.synchronizedSet(new HashSet());
    private boolean isGoingToShutdown;
    private boolean analyzing;
    private static ShutdownManageLink instance;
    private static final String URL = "lenientshutdown";
    private static final String ICON = "symbol-power";

    public static ShutdownManageLink getInstance() {
        List list = Jenkins.get().getManagementLinks();
        for (ManagementLink link : list) {
            if (!(link instanceof ShutdownManageLink)) continue;
            instance = (ShutdownManageLink)link;
            break;
        }
        return instance;
    }

    public String getIconFileName() {
        return ICON;
    }

    public String getDisplayName() {
        if (this.isGoingToShutdown()) {
            return Messages.CancelShutdownTitle();
        }
        return Messages.ActivateShutdownTitle();
    }

    public String getUrlName() {
        if (this.isGoingToShutdown) {
            return "cancelLenientShutdown";
        }
        return URL;
    }

    public String getDescription() {
        String description = null;
        if (!this.isGoingToShutdown()) {
            description = Messages.Description();
        }
        return description;
    }

    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public void toggleGoingToShutdown() {
        this.analyzing = this.isGoingToShutdown = !this.isGoingToShutdown;
    }

    public boolean isGoingToShutdown() {
        return this.isGoingToShutdown;
    }

    public ShutdownConfiguration getConfiguration() {
        return ShutdownConfiguration.getInstance();
    }

    public synchronized void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Jenkins.get().checkPermission(this.getRequiredPermission());
        this.performToggleGoingToShutdown();
        rsp.sendRedirect2(req.getContextPath() + "/manage");
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Fire and forget for asynchronous processing")
    public void performToggleGoingToShutdown() {
        this.toggleGoingToShutdown();
        if (this.isGoingToShutdown()) {
            SecurityContextExecutorService service = new SecurityContextExecutorService(Executors.newSingleThreadExecutor());
            service.submit(new Runnable(){

                @Override
                public void run() {
                    ShutdownManageLink.this.permittedQueueIds.clear();
                    ShutdownManageLink.this.activeQueueIds.clear();
                    ShutdownManageLink.this.whiteListedQueueIds.clear();
                    ShutdownManageLink.this.permittedQueueIds.addAll(QueueUtils.getPermittedQueueItemIds());
                    ShutdownManageLink.this.permittedQueueIds.addAll(QueueUtils.getRunningProjectQueueIds());
                    ShutdownManageLink.this.activeQueueIds.addAll(ShutdownManageLink.this.permittedQueueIds);
                    ShutdownManageLink.this.analyzing = false;
                }
            });
        }
    }

    public boolean isAnalyzing() {
        return this.analyzing;
    }

    public boolean isAnyPermittedUpstreamProject(Set<Long> queueIds) {
        Collection intersection = CollectionUtils.intersection(queueIds, this.permittedQueueIds);
        return !intersection.isEmpty();
    }

    public boolean isAnyWhiteListedUpstreamProject(Set<Long> queueIds) {
        Collection intersection = CollectionUtils.intersection(queueIds, this.whiteListedQueueIds);
        return !intersection.isEmpty();
    }

    public boolean isActiveQueueIds() {
        return !this.activeQueueIds.isEmpty();
    }

    public void addActiveQueueId(long id) {
        this.activeQueueIds.add(id);
    }

    public void removeActiveQueueId(long id) {
        this.activeQueueIds.remove(id);
    }

    public void addPermittedUpstreamQueueId(long id) {
        this.permittedQueueIds.add(id);
    }

    public boolean isPermittedQueueId(long id) {
        return this.permittedQueueIds.contains(id);
    }

    public void addWhiteListedQueueId(long id) {
        this.whiteListedQueueIds.add(id);
    }
}

