/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.Messages;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class ShutdownConfiguration
extends GlobalConfiguration {
    private static final String DELIMETER = "\\r?\\n";
    private String shutdownMessage = Messages.GoingToShutDown();
    private boolean allowAllQueuedItems;
    private boolean allowWhiteListedProjects;
    private boolean allowAllJobs;
    private Set<String> whiteListedProjects = Collections.synchronizedSet(new TreeSet());

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="The #load() method is documented as: 'The constructor of the derived class must call this method.'")
    public ShutdownConfiguration() {
        this.load();
    }

    public boolean isAllowAllQueuedItems() {
        return this.allowAllQueuedItems;
    }

    public boolean isAllowWhiteListedProjects() {
        return this.allowWhiteListedProjects;
    }

    public boolean isAllowAllJobs() {
        return this.allowAllJobs;
    }

    public void setAllowAllQueuedItems(boolean allowAllQueuedItems) {
        this.allowAllQueuedItems = allowAllQueuedItems;
    }

    public void setAllowWhiteListedProjects(boolean allowWhiteListedProjects) {
        this.allowWhiteListedProjects = allowWhiteListedProjects;
    }

    public void setAllowAllJobs(boolean allowAllJobs) {
        this.allowAllJobs = allowAllJobs;
    }

    public String getShutdownMessage() {
        return this.shutdownMessage;
    }

    public void setShutdownMessage(String shutdownMessage) {
        this.shutdownMessage = shutdownMessage;
    }

    public String getWhiteListedProjectsText() {
        return StringUtils.join(this.whiteListedProjects, (String)"\n");
    }

    public Set<String> getWhiteListedProjects() {
        return this.whiteListedProjects;
    }

    public boolean isWhiteListedProject(String name) {
        return this.allowWhiteListedProjects && this.whiteListedProjects.contains(name);
    }

    public boolean configure(StaplerRequest2 staplerRequest, JSONObject json) throws Descriptor.FormException {
        this.shutdownMessage = json.getString("shutdownMessage");
        this.allowAllQueuedItems = json.getBoolean("allowAllQueuedItems");
        this.allowWhiteListedProjects = json.getBoolean("allowWhiteListedProjects");
        this.allowAllJobs = json.getBoolean("allowAllJobs");
        this.whiteListedProjects.clear();
        this.whiteListedProjects.addAll(Arrays.asList(json.getString("whiteListedProjects").split(DELIMETER)));
        this.save();
        return true;
    }

    public static ShutdownConfiguration getInstance() {
        return (ShutdownConfiguration)((Object)GlobalConfiguration.all().get(ShutdownConfiguration.class));
    }
}

