/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;

public final class QueueUtils {
    private QueueUtils() {
    }

    public static Set<Long> getPermittedQueueItemIds() {
        HashSet<Long> queuedIds = new HashSet<Long>();
        boolean allowAllQueuedItems = ShutdownConfiguration.getInstance().isAllowAllQueuedItems();
        block0: for (Queue.Item item : Queue.getInstance().getItems()) {
            if (QueueUtils.isApplicable(item.task)) {
                if (allowAllQueuedItems) {
                    queuedIds.add(item.getId());
                    continue;
                }
                for (AbstractBuild upstreamBuild : QueueUtils.getUpstreamBuilds(item)) {
                    if (upstreamBuild.isBuilding()) continue;
                    queuedIds.add(item.getId());
                    continue block0;
                }
                continue;
            }
            queuedIds.add(item.getId());
        }
        return Collections.unmodifiableSet(queuedIds);
    }

    public static boolean isApplicable(Queue.Task task) {
        if (ShutdownConfiguration.getInstance().isAllowAllJobs()) {
            return task instanceof Job;
        }
        return task instanceof AbstractProject;
    }

    public static Set<Long> getPermittedQueueItemIds(String nodeName) {
        HashSet<Long> permittedQueueItemIds = new HashSet<Long>();
        if (nodeName == null) {
            permittedQueueItemIds.addAll(QueueUtils.getPermittedQueueItemIds());
        } else {
            Queue queueInstance = Queue.getInstance();
            Node node = Jenkins.get().getNode(nodeName);
            if (nodeName.isEmpty()) {
                node = Jenkins.get();
            }
            if (node != null) {
                for (long id : QueueUtils.getPermittedQueueItemIds()) {
                    Queue.Item item = queueInstance.getItem(id);
                    if (item == null || QueueUtils.canOtherNodeBuild(item, node)) continue;
                    permittedQueueItemIds.add(id);
                }
            }
        }
        return Collections.unmodifiableSet(permittedQueueItemIds);
    }

    public static Set<Long> getRunningProjectQueueIds() {
        HashSet<Long> runningProjects = new HashSet<Long>();
        ArrayList<Jenkins> allNodes = new ArrayList<Jenkins>(Jenkins.get().getNodes());
        allNodes.add(Jenkins.get());
        for (Node node : allNodes) {
            runningProjects.addAll(QueueUtils.getRunninProjectsQueueIDs(node.getNodeName()));
        }
        return Collections.unmodifiableSet(runningProjects);
    }

    public static Set<Long> getRunninProjectsQueueIDs(String nodeName) {
        Computer computer;
        HashSet<Long> runningProjects = new HashSet<Long>();
        Node node = Jenkins.get().getNode(nodeName);
        if (nodeName.isEmpty()) {
            node = Jenkins.get();
        }
        if (node != null && (computer = node.toComputer()) != null) {
            ArrayList executors = new ArrayList(computer.getExecutors());
            executors.addAll(computer.getOneOffExecutors());
            for (Executor executor : executors) {
                Queue.Executable executable = executor.getCurrentExecutable();
                if (!(executable instanceof AbstractBuild)) continue;
                AbstractBuild build = (AbstractBuild)executable;
                runningProjects.add(build.getQueueId());
            }
        }
        return Collections.unmodifiableSet(runningProjects);
    }

    public static Set<Long> getUpstreamQueueIds(Queue.Item item) {
        HashSet<Long> upstreamProjects = new HashSet<Long>();
        for (Cause cause : item.getCauses()) {
            Cause.UpstreamCause upstreamCause;
            Run run;
            if (!(cause instanceof Cause.UpstreamCause) || (run = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) == null) continue;
            upstreamProjects.add(run.getQueueId());
        }
        return Collections.unmodifiableSet(upstreamProjects);
    }

    public static Set<AbstractBuild> getUpstreamBuilds(Queue.Item item) {
        HashSet<AbstractBuild> upstreamBuilds = new HashSet<AbstractBuild>();
        for (Cause cause : item.getCauses()) {
            Cause.UpstreamCause upstreamCause;
            Run upstreamRun;
            if (!(cause instanceof Cause.UpstreamCause) || (upstreamRun = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) == null || !(upstreamRun instanceof AbstractBuild)) continue;
            upstreamBuilds.add((AbstractBuild)upstreamRun);
        }
        return Collections.unmodifiableSet(upstreamBuilds);
    }

    public static boolean canOtherNodeBuild(Queue.Item item, Node node) {
        boolean otherNodeCanBuild;
        block2: {
            block3: {
                otherNodeCanBuild = false;
                if (!(item instanceof Queue.BuildableItem)) break block3;
                Queue.BuildableItem buildableItem = (Queue.BuildableItem)item;
                HashSet<Jenkins> allNodes = new HashSet<Jenkins>(Jenkins.get().getNodes());
                allNodes.add(Jenkins.get());
                for (Node node2 : allNodes) {
                    Computer otherComputer = node2.toComputer();
                    if (otherComputer == null || !otherComputer.isOnline() || node2.equals(node) || node2.canTake(buildableItem) != null) continue;
                    otherNodeCanBuild = true;
                    break block2;
                }
                break block2;
            }
            if (!(item instanceof Queue.WaitingItem)) break block2;
            otherNodeCanBuild = true;
            for (AbstractBuild upstreamBuild : QueueUtils.getUpstreamBuilds(item)) {
                boolean isUpstreamFinished = !upstreamBuild.isBuilding();
                if (!isUpstreamFinished || !upstreamBuild.getBuiltOnStr().equals(node.getNodeName())) continue;
                otherNodeCanBuild = false;
                break;
            }
        }
        return otherNodeCanBuild;
    }

    public static boolean isBuilding(Computer computer) {
        boolean isBuilding = false;
        ArrayList executors = new ArrayList(computer.getExecutors());
        executors.addAll(computer.getOneOffExecutors());
        for (Executor executor : executors) {
            if (!executor.isBusy()) continue;
            isBuilding = true;
            break;
        }
        return isBuilding;
    }

    public static boolean hasNodeExclusiveItemInQueue(Computer computer) {
        Queue.Item[] queueItems;
        boolean hasExclusive = false;
        for (Queue.Item item : queueItems = Queue.getInstance().getItems()) {
            if (QueueUtils.canOtherNodeBuild(item, computer.getNode())) continue;
            hasExclusive = true;
            break;
        }
        return hasExclusive;
    }
}

