/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.LenientOfflineCause;
import com.sonymobile.jenkins.plugins.lenientshutdown.QueueUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Plugin;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.User;
import hudson.slaves.OfflineCause;
import hudson.util.CopyOnWriteMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import jenkins.model.Jenkins;
import jenkins.security.SecurityContextExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PluginImpl
extends Plugin {
    private transient Map<String, Boolean> lenientOfflineSlaves = new CopyOnWriteMap.Hash();
    private transient Map<String, User> userTriggers = new CopyOnWriteMap.Hash();
    private Map<String, Set<Long>> permittedSlaveQueuedItemIds = Collections.synchronizedMap(new HashMap());

    public static PluginImpl getInstance() {
        return (PluginImpl)Jenkins.get().getPlugin(PluginImpl.class);
    }

    static boolean isTemporarilyOffline(Computer computer) {
        Node node = computer.getNode();
        return node != null && node.getTemporaryOfflineCause() != null;
    }

    public boolean isNodeShuttingDown(String nodeName) {
        return this.lenientOfflineSlaves.containsKey(nodeName) && this.lenientOfflineSlaves.get(nodeName) != false;
    }

    public synchronized void toggleNodeShuttingDown(String nodeName) {
        Boolean nodeShuttingDown = this.lenientOfflineSlaves.get(nodeName);
        if (nodeShuttingDown == null) {
            this.lenientOfflineSlaves.put(nodeName, true);
        } else {
            this.lenientOfflineSlaves.put(nodeName, nodeShuttingDown == false);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Fire and forget for asynchronous processing")
    public void setNodeOffline(Computer computer) {
        if (computer == null) {
            return;
        }
        Node node = computer.getNode();
        if (node == null) {
            return;
        }
        if (QueueUtils.isBuilding(computer) || QueueUtils.hasNodeExclusiveItemInQueue(computer)) {
            final String nodeName = node.getNodeName();
            this.toggleNodeShuttingDown(nodeName);
            this.setOfflineByUser(nodeName, User.current());
            SecurityContextExecutorService service = new SecurityContextExecutorService(Executors.newSingleThreadExecutor());
            service.submit(new Runnable(){

                @Override
                public void run() {
                    Set<Long> permittedQueuedItemIds = PluginImpl.this.getPermittedQueuedItemIds(nodeName);
                    permittedQueuedItemIds.clear();
                    permittedQueuedItemIds.addAll(QueueUtils.getPermittedQueueItemIds(nodeName));
                    permittedQueuedItemIds.addAll(QueueUtils.getRunninProjectsQueueIDs(nodeName));
                }
            });
        } else {
            User currentUser = User.current();
            if (currentUser == null) {
                currentUser = User.getUnknown();
            }
            computer.setTemporaryOfflineCause((OfflineCause)new LenientOfflineCause(currentUser));
        }
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isAnyPermittedUpstreamQueueId(Set<Long> queueItemsIds, String nodeName) {
        boolean isPermitted = false;
        Set<Long> permittedQueueItemIds = this.getPermittedQueuedItemIds(nodeName);
        Collection intersection = CollectionUtils.intersection(queueItemsIds, permittedQueueItemIds);
        isPermitted = !intersection.isEmpty();
        return isPermitted;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean wasAlreadyQueued(long id, String nodeName) {
        Set<Long> alreadyQueuedItemIds = this.getPermittedQueuedItemIds(nodeName);
        return alreadyQueuedItemIds.contains(id);
    }

    @Restricted(value={NoExternalUse.class})
    public void addPermittedUpstreamQueueId(long id, String nodeName) {
        Set<Long> permittedUpstreamProjectNames = this.getPermittedQueuedItemIds(nodeName);
        permittedUpstreamProjectNames.add(id);
    }

    public void setOfflineByUser(String nodeName, User user) {
        this.userTriggers.put(nodeName, user);
    }

    public User getOfflineByUser(String nodeName) {
        User user = this.userTriggers.get(nodeName);
        if (user == null) {
            user = User.getUnknown();
        }
        return user;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized Set<Long> getPermittedQueuedItemIds(String nodeName) {
        Set<Long> permittedQueuedItemIds = this.permittedSlaveQueuedItemIds.get(nodeName);
        if (permittedQueuedItemIds == null) {
            permittedQueuedItemIds = new HashSet<Long>();
            this.permittedSlaveQueuedItemIds.put(nodeName, permittedQueuedItemIds);
        }
        return permittedQueuedItemIds;
    }
}

