/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.jenkins.plugins.lenientshutdown;

import com.sonymobile.jenkins.plugins.lenientshutdown.PluginImpl;
import com.sonymobile.jenkins.plugins.lenientshutdown.QueueUtils;
import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownConfiguration;
import com.sonymobile.jenkins.plugins.lenientshutdown.ShutdownManageLink;
import com.sonymobile.jenkins.plugins.lenientshutdown.blockcauses.GlobalShutdownBlockage;
import com.sonymobile.jenkins.plugins.lenientshutdown.blockcauses.NodeShutdownBlockage;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class BuildPreventer
extends QueueTaskDispatcher {
    private static final Logger logger = Logger.getLogger(BuildPreventer.class.getName());

    public CauseOfBlockage canRun(Queue.Item item) {
        GlobalShutdownBlockage blockage = null;
        ShutdownManageLink shutdownManageLink = ShutdownManageLink.getInstance();
        boolean isGoingToShutdown = shutdownManageLink.isGoingToShutdown();
        ShutdownConfiguration configuration = ShutdownConfiguration.getInstance();
        boolean isWhitelistedProject = false;
        boolean isWhiteListedUpStreamProject = false;
        if (isGoingToShutdown && QueueUtils.isApplicable(item.task) && !shutdownManageLink.isPermittedQueueId(item.getId())) {
            Job project = (Job)item.task;
            isWhitelistedProject = shutdownManageLink.isActiveQueueIds() && configuration.isWhiteListedProject(project.getFullName());
            Set<Long> upstreamQueueIds = QueueUtils.getUpstreamQueueIds(item);
            boolean isPermittedByUpStream = shutdownManageLink.isAnyPermittedUpstreamProject(upstreamQueueIds);
            isWhiteListedUpStreamProject = shutdownManageLink.isAnyWhiteListedUpstreamProject(upstreamQueueIds);
            if (!(isPermittedByUpStream || isWhitelistedProject || isWhiteListedUpStreamProject)) {
                logger.log(Level.FINE, "Preventing project {0} from running, since lenient shutdown is active", project.getFullName());
                blockage = new GlobalShutdownBlockage();
            } else if (isPermittedByUpStream) {
                isWhitelistedProject = false;
            }
        }
        if (blockage == null && isGoingToShutdown) {
            if (isWhitelistedProject || isWhiteListedUpStreamProject) {
                shutdownManageLink.addWhiteListedQueueId(item.getId());
            } else {
                shutdownManageLink.addPermittedUpstreamQueueId(item.getId());
                shutdownManageLink.addActiveQueueId(item.getId());
            }
        }
        return blockage;
    }

    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        String nodeName;
        NodeShutdownBlockage blockage = null;
        PluginImpl plugin = PluginImpl.getInstance();
        boolean nodeIsGoingToShutdown = plugin.isNodeShuttingDown(nodeName = node.getNodeName());
        if (nodeIsGoingToShutdown && QueueUtils.isApplicable(item.task) && !plugin.wasAlreadyQueued(item.getId(), nodeName)) {
            boolean otherNodeCanBuild = QueueUtils.canOtherNodeBuild((Queue.Item)item, node);
            Set<Long> upstreamQueueIds = QueueUtils.getUpstreamQueueIds((Queue.Item)item);
            if (otherNodeCanBuild || !plugin.isAnyPermittedUpstreamQueueId(upstreamQueueIds, nodeName)) {
                logger.log(Level.FINE, "Preventing project {0} from running on node {1}, since lenient shutdown is active", new String[]{item.getDisplayName(), nodeName});
                blockage = new NodeShutdownBlockage();
            }
        }
        if (blockage == null && nodeIsGoingToShutdown) {
            plugin.addPermittedUpstreamQueueId(item.getId(), nodeName);
        }
        return blockage;
    }
}

