/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;

public final class TextAccessor {
    private static final char PROTECTED_SPACE = '\u00a0';
    private final List<String> textForms;

    TextAccessor(String[] stringArray) {
        this.textForms = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    public String print(Enum<?> enum_) {
        int n = enum_.ordinal();
        if (this.textForms.size() <= n) {
            return enum_.name();
        }
        return this.textForms.get(n);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz) {
        return this.parse(charSequence, parsePosition, clazz, true, false, true);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, Leniency leniency) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        if (leniency == Leniency.STRICT) {
            bl = false;
            bl3 = false;
        } else if (leniency == Leniency.LAX) {
            bl2 = true;
        }
        return this.parse(charSequence, parsePosition, clazz, bl, bl2, bl3);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, AttributeQuery attributeQuery) {
        boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        boolean bl2 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
        boolean bl3 = attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE);
        return this.parse(charSequence, parsePosition, clazz, bl, bl2, bl3);
    }

    public List<String> getTextForms() {
        return this.textForms;
    }

    public String toString() {
        int n = this.textForms.size();
        StringBuilder stringBuilder = new StringBuilder(n * 16 + 2);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.textForms.get(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, boolean bl, boolean bl2, boolean bl3) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n = this.textForms.size();
        int n2 = parsePosition.getIndex();
        int n3 = charSequence.length();
        String string = "";
        int n4 = 0;
        Enum enum_ = null;
        for (int i = 0; i < enumArray.length; ++i) {
            int n5;
            boolean bl4 = string.isEmpty();
            String string2 = bl4 ? (i >= n ? enumArray[i].name() : this.textForms.get(i)) : string;
            int n6 = n2;
            int n7 = string2.length();
            boolean bl5 = true;
            for (n5 = 0; bl5 && n5 < n7; ++n5) {
                if (n2 + n5 >= n3) {
                    bl5 = false;
                    continue;
                }
                char c = charSequence.charAt(n2 + n5);
                char c2 = string2.charAt(n5);
                if (bl3) {
                    if (c == '\u00a0') {
                        c = ' ';
                    }
                    if (c2 == '\u00a0') {
                        c2 = ' ';
                    }
                }
                if (bl) {
                    bl5 = c == c2 || this.compareIgnoreCase(c, c2);
                } else {
                    boolean bl6 = bl5 = c == c2;
                }
                if (!bl5) continue;
                ++n6;
            }
            if (bl3 && bl4 && n7 == 5 && string2.charAt(4) == '.' && n6 == (n5 = n2 + 3) && n5 < n3 && charSequence.charAt(n5) == '.') {
                string = string2.subSequence(n2, n5) + ".";
                --i;
                continue;
            }
            string = "";
            if (bl2 || n7 == 1) {
                if (n4 < n6 - n2) {
                    n4 = n6 - n2;
                    enum_ = enumArray[i];
                    continue;
                }
                if (n4 != n6 - n2) continue;
                enum_ = null;
                continue;
            }
            if (!bl5) continue;
            assert (n6 == n2 + n7);
            parsePosition.setIndex(n6);
            return (V)enumArray[i];
        }
        if (enum_ == null) {
            parsePosition.setErrorIndex(n2);
        } else {
            parsePosition.setIndex(n2 + n4);
        }
        return (V)enum_;
    }

    private boolean compareIgnoreCase(char c, char c2) {
        if (c >= 'a' && c <= 'z') {
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 97 - 65);
            }
            return c == c2;
        }
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 97 - 65);
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 97 - 65);
            }
            return c == c2;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }
}

