/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.time4j.Moment;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.scale.TimeScale;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.SPX;
import net.time4j.tz.model.TransitionModel;

final class ArrayTransitionModel
extends TransitionModel {
    private static final long serialVersionUID = -5264909488983076587L;
    private final transient ZonalTransition[] transitions;
    private final transient boolean negativeDST;
    private final transient List<ZonalTransition> stdTransitions;
    private transient int hash = 0;

    ArrayTransitionModel(List<ZonalTransition> list) {
        this(list, true, true);
    }

    ArrayTransitionModel(List<ZonalTransition> list, boolean bl, boolean bl2) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing timezone transitions.");
        }
        int n = list.size();
        Object[] objectArray = new ZonalTransition[n];
        objectArray = list.toArray(objectArray);
        boolean bl3 = false;
        for (ZonalTransition zonalTransition : objectArray) {
            bl3 = bl3 || zonalTransition.getExtraOffset() < 0;
        }
        this.negativeDST = bl3;
        if (bl) {
            Arrays.sort(objectArray);
        }
        if (bl2) {
            ArrayTransitionModel.checkSanity((ZonalTransition[])objectArray, list);
        }
        this.transitions = objectArray;
        long l = TransitionModel.getFutureMoment(1);
        this.stdTransitions = ArrayTransitionModel.getTransitions(this.transitions, 0L, l);
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return ZonalOffset.ofTotalSeconds(this.transitions[0].getPreviousOffset());
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        int n = ArrayTransitionModel.search(unixTime.getPosixTime(), this.transitions);
        return n == 0 ? null : this.transitions[n - 1];
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        return this.getConflictTransition(gregorianDate, wallTime, null);
    }

    @Override
    public Optional<ZonalTransition> findNextTransition(UnixTime unixTime) {
        int n = ArrayTransitionModel.search(unixTime.getPosixTime(), this.transitions);
        return n == this.transitions.length ? Optional.empty() : Optional.of(this.transitions[n]);
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        return this.getValidOffsets(gregorianDate, wallTime, null);
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return this.stdTransitions;
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        return ArrayTransitionModel.getTransitions(this.transitions, unixTime.getPosixTime(), unixTime2.getPosixTime());
    }

    @Override
    public void dump(Appendable appendable) throws IOException {
        this.dump(this.transitions.length, appendable);
    }

    @Override
    public boolean hasNegativeDST() {
        return this.negativeDST;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ArrayTransitionModel) {
            ArrayTransitionModel arrayTransitionModel = (ArrayTransitionModel)object;
            return Arrays.equals(this.transitions, arrayTransitionModel.transitions);
        }
        return false;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            this.hash = n = Arrays.hashCode(this.transitions);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[transition-count=");
        stringBuilder.append(this.transitions.length);
        stringBuilder.append(",hash=");
        stringBuilder.append(this.hashCode());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime, RuleBasedTransitionModel ruleBasedTransitionModel) {
        long l = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        int n = ArrayTransitionModel.searchLocal(l, this.transitions);
        if (n == this.transitions.length) {
            return ruleBasedTransitionModel == null ? null : ruleBasedTransitionModel.getConflictTransition(gregorianDate, l);
        }
        ZonalTransition zonalTransition = this.transitions[n];
        if (zonalTransition.isGap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() > l);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() <= l) {
                return zonalTransition;
            }
        } else if (zonalTransition.isOverlap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() > l);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() <= l) {
                return zonalTransition;
            }
        }
        return null;
    }

    List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime, RuleBasedTransitionModel ruleBasedTransitionModel) {
        long l = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        int n = ArrayTransitionModel.searchLocal(l, this.transitions);
        if (n == this.transitions.length) {
            if (ruleBasedTransitionModel == null) {
                ZonalTransition zonalTransition = this.transitions[this.transitions.length - 1];
                return TransitionModel.toList(zonalTransition.getTotalOffset());
            }
            return ruleBasedTransitionModel.getValidOffsets(gregorianDate, l);
        }
        ZonalTransition zonalTransition = this.transitions[n];
        if (zonalTransition.isGap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() > l);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() <= l) {
                return Collections.emptyList();
            }
        } else if (zonalTransition.isOverlap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() > l);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() <= l) {
                return TransitionModel.toList(zonalTransition.getTotalOffset(), zonalTransition.getPreviousOffset());
            }
        }
        return TransitionModel.toList(zonalTransition.getPreviousOffset());
    }

    void dump(int n, Appendable appendable) throws IOException {
        for (int i = 0; i < n; ++i) {
            ZonalTransition zonalTransition = this.transitions[i];
            TransitionModel.dump(zonalTransition, appendable);
        }
    }

    ZonalTransition getLastTransition() {
        return this.transitions[this.transitions.length - 1];
    }

    boolean equals(ArrayTransitionModel arrayTransitionModel, int n, int n2) {
        int n3;
        int n4 = Math.min(n, this.transitions.length);
        if (n4 != (n3 = Math.min(n2, arrayTransitionModel.transitions.length))) {
            return false;
        }
        for (int i = 0; i < n4; ++i) {
            if (this.transitions[i].equals(arrayTransitionModel.transitions[i])) continue;
            return false;
        }
        return true;
    }

    int hashCode(int n) {
        int n2 = Math.min(n, this.transitions.length);
        Object[] objectArray = new ZonalTransition[n2];
        System.arraycopy(this.transitions, 0, objectArray, 0, n2);
        return Arrays.hashCode(objectArray);
    }

    void writeTransitions(ObjectOutput objectOutput) throws IOException {
        this.writeTransitions(this.transitions.length, objectOutput);
    }

    void writeTransitions(int n, ObjectOutput objectOutput) throws IOException {
        SPX.writeTransitions(this.transitions, n, objectOutput);
    }

    private static void checkSanity(ZonalTransition[] zonalTransitionArray, List<ZonalTransition> list) {
        int n = zonalTransitionArray[0].getTotalOffset();
        for (int i = 1; i < zonalTransitionArray.length; ++i) {
            if (n != zonalTransitionArray[i].getPreviousOffset()) {
                Moment moment = Moment.of(zonalTransitionArray[i].getPosixTime(), TimeScale.POSIX);
                throw new IllegalArgumentException("Model inconsistency detected at: " + moment + " (" + zonalTransitionArray[i].getPosixTime() + ")  in transitions: " + list);
            }
            n = zonalTransitionArray[i].getTotalOffset();
        }
    }

    private static List<ZonalTransition> getTransitions(ZonalTransition[] zonalTransitionArray, long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("Start after end.");
        }
        int n = ArrayTransitionModel.search(l, zonalTransitionArray);
        int n2 = ArrayTransitionModel.search(l2, zonalTransitionArray);
        if (n2 == 0) {
            return Collections.emptyList();
        }
        if (n > 0 && zonalTransitionArray[n - 1].getPosixTime() == l) {
            --n;
        }
        if (zonalTransitionArray[--n2].getPosixTime() == l2) {
            --n2;
        }
        if (n > n2) {
            return Collections.emptyList();
        }
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            arrayList.add(zonalTransitionArray[i]);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static int search(long l, ZonalTransition[] zonalTransitionArray) {
        int n = 0;
        int n2 = zonalTransitionArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (zonalTransitionArray[n3].getPosixTime() <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    private static int searchLocal(long l, ZonalTransition[] zonalTransitionArray) {
        int n = 0;
        int n2 = zonalTransitionArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            ZonalTransition zonalTransition = zonalTransitionArray[n3];
            int n4 = Math.max(zonalTransition.getTotalOffset(), zonalTransition.getPreviousOffset());
            if (zonalTransition.getPosixTime() + (long)n4 <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    private Object writeReplace() {
        return new SPX(this, 126);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

