/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import net.time4j.engine.TimePoint;

public interface TimeSpan<U> {
    public List<Item<U>> getTotalLength();

    public boolean contains(U var1);

    public long getPartialAmount(U var1);

    public boolean isNegative();

    public boolean isPositive();

    public boolean isEmpty();

    public <T extends TimePoint<? super U, T>> T addTo(T var1);

    public <T extends TimePoint<? super U, T>> T subtractFrom(T var1);

    public static class Item<U>
    implements Serializable {
        private static final long serialVersionUID = 1564804888291509484L;
        private final U unit;
        private final long amount;

        private Item(long l, U u) {
            if (u == null) {
                throw new NullPointerException("Missing chronological unit.");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("Temporal amount must be positive or zero: " + l);
            }
            this.amount = l;
            this.unit = u;
        }

        public static <U> Item<U> of(long l, U u) {
            return new Item<U>(l, u);
        }

        public long getAmount() {
            return this.amount;
        }

        public U getUnit() {
            return this.unit;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Item) {
                Item item = (Item)Item.class.cast(object);
                return this.amount == item.amount && this.unit.equals(item.unit);
            }
            return false;
        }

        public int hashCode() {
            int n = this.unit.hashCode();
            n = 29 * n + (int)(this.amount ^ this.amount >>> 32);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('P');
            stringBuilder.append(this.amount);
            stringBuilder.append('{');
            stringBuilder.append(this.unit);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.unit == null || this.amount < 0L) {
                throw new InvalidObjectException("Inconsistent state.");
            }
        }
    }
}

