/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.bahai;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.bahai.BadiCalendar;
import net.time4j.calendar.bahai.BadiIntercalaryDays;
import net.time4j.calendar.bahai.BadiMonth;

final class SPX
implements Externalizable {
    static final int BAHAI = 19;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 19: {
                this.writeBahai(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        switch (by) {
            case 19: {
                this.obj = this.readBahai(objectInput);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeBahai(ObjectOutput objectOutput) throws IOException {
        BadiCalendar badiCalendar = (BadiCalendar)this.obj;
        objectOutput.writeByte(badiCalendar.getKullishai());
        objectOutput.writeByte(badiCalendar.getVahid());
        objectOutput.writeByte(badiCalendar.getYearOfVahid());
        objectOutput.writeByte(badiCalendar.hasMonth() ? badiCalendar.getMonth().getValue() : 0);
        objectOutput.writeByte(badiCalendar.getDayOfDivision());
    }

    private BadiCalendar readBahai(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        byte by3 = objectInput.readByte();
        byte by4 = objectInput.readByte();
        byte by5 = objectInput.readByte();
        Enum enum_ = by4 == 0 ? BadiIntercalaryDays.AYYAM_I_HA : BadiMonth.valueOf(by4);
        return BadiCalendar.ofComplete(by, by2, by3, enum_, by5);
    }
}

