/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.calendar.astro.EquatorialCoordinates;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.SkyPosition;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.engine.ChronoCondition;

public enum Zodiac {
    ARIES('\u2648', 26.766, 11.048),
    TAURUS('\u2649', 51.113, 18.648),
    GEMINI('\u264a', 90.218, 23.439),
    CANCER('\u264b', 120.198, 20.542),
    LEO('\u264c', 140.637, 15.375),
    VIRGO('\u264d', 174.4, 2.423),
    LIBRA('\u264e', 215.634, -14.176),
    SCORPIUS('\u264f', 238.861, -20.359),
    OPHIUCHUS('\u26ce', 245.915, -21.594),
    SAGITTARIUS('\u2650', 265.968, -23.388),
    CAPRICORNUS('\u2651', 301.869, -20.214),
    AQUARIUS('\u2652', 329.79, -12.306),
    PISCES('\u2653', 352.284, -3.331);

    private static final Map<String, String[]> LANG_TO_NAMES;
    private static final double MEAN_TROPICAL_YEAR = 365.242189;
    private static final double MEAN_SYNODIC_MONTH = 29.530588861;
    private final transient char symbol;
    private final transient EquatorialCoordinates entry;

    private Zodiac(char c, double d, double d2) {
        this.symbol = c;
        this.entry = new SkyPosition(d, d2);
    }

    public static Zodiac constellationPassedBySun(Moment moment) {
        return Zodiac.of('S', moment, false);
    }

    public static Zodiac constellationPassedByMoon(Moment moment) {
        return Zodiac.of('L', moment, false);
    }

    public static Zodiac signPassedBySun(Moment moment) {
        return Zodiac.of('S', moment, true);
    }

    public static Zodiac signPassedByMoon(Moment moment) {
        return Zodiac.of('L', moment, true);
    }

    public char getSymbol() {
        return this.symbol;
    }

    public String getDisplayName(Locale locale) {
        String[] stringArray = LANG_TO_NAMES.get(locale.getLanguage());
        if (stringArray == null) {
            stringArray = LANG_TO_NAMES.get("");
        }
        return stringArray[this.ordinal()];
    }

    public Zodiac previous() {
        return Zodiac.values()[(this.ordinal() + 12) % 13];
    }

    public Zodiac next() {
        return Zodiac.values()[(this.ordinal() + 1) % 13];
    }

    private static Zodiac of(char c, Moment moment, boolean bl) {
        Moment moment2 = (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
        double d = JulianDay.ofEphemerisTime(moment2).getValue();
        double d2 = c == 'S' ? Zodiac.getSolarLongitude(d) : Zodiac.getLunarLongitude(d);
        for (Zodiac zodiac : Zodiac.values()) {
            double d3;
            double d4;
            Zodiac zodiac2 = zodiac.next();
            if (bl) {
                if (zodiac == OPHIUCHUS) continue;
                if (zodiac2 == OPHIUCHUS) {
                    zodiac2 = SAGITTARIUS;
                }
                int n = zodiac.compareTo(OPHIUCHUS) < 0 ? 0 : -1;
                int n2 = zodiac2.compareTo(OPHIUCHUS) < 0 ? 0 : -1;
                d4 = (zodiac.ordinal() + n) * 30;
                d3 = (zodiac2.ordinal() + n2) * 30;
            } else {
                d4 = Zodiac.toEclipticAngle(moment2, zodiac.entry.getRightAscension(), zodiac.entry.getDeclination());
                d3 = Zodiac.toEclipticAngle(moment2, zodiac2.entry.getRightAscension(), zodiac2.entry.getDeclination());
            }
            if (d3 < d4) {
                d3 += 360.0;
                if (d2 < 180.0) {
                    d2 += 360.0;
                }
            }
            if (!(d2 >= d4) || !(d2 < d3)) continue;
            return zodiac;
        }
        throw new NoSuchElementException("Unable to determine zodiac.");
    }

    private static double getSolarLongitude(double d) {
        return StdSolarCalculator.TIME4J.getFeature(d, "solar-longitude");
    }

    private static double getLunarLongitude(double d) {
        return StdSolarCalculator.TIME4J.getFeature(d, "lunar-longitude");
    }

    private static double toEclipticAngle(Moment moment, double d, double d2) {
        double d3 = JulianDay.ofSimplifiedTime(moment).getCenturyJ2000();
        double d4 = Math.toRadians(StdSolarCalculator.meanObliquity(d3));
        double d5 = (2306.2181 + (0.30188 + 0.017998 * d3) * d3) * d3 / 3600.0;
        double d6 = (2306.2181 + (1.09468 + 0.018203 * d3) * d3) * d3 / 3600.0;
        double d7 = (2004.3109 - (0.42665 + 0.041833 * d3) * d3) * d3 / 3600.0;
        double d8 = Math.toRadians(d + d5);
        double d9 = Math.cos(d8);
        double d10 = Math.cos(Math.toRadians(d7));
        double d11 = Math.sin(Math.toRadians(d7));
        double d12 = Math.cos(Math.toRadians(d2));
        double d13 = Math.sin(Math.toRadians(d2));
        double d14 = d12 * Math.sin(d8);
        double d15 = d10 * d12 * d9 - d11 * d13;
        double d16 = d11 * d12 * d9 + d10 * d13;
        double d17 = Math.toRadians(Math.toDegrees(Math.atan2(d14, d15)) + d6);
        double d18 = Math.asin(d16);
        double d19 = Math.toDegrees(Math.atan2(Math.sin(d17) * Math.cos(d4) + Math.tan(d18) * Math.sin(d4), Math.cos(d17)));
        if (d19 < 0.0) {
            d19 += 360.0;
        }
        return d19;
    }

    static {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("", new String[]{"Aries", "Taurus", "Gemini", "Cancer", "Leo", "Virgo", "Libra", "Scorpius", "Ophiuchus", "Sagittarius", "Capricornus", "Aquarius", "Pisces"});
        hashMap.put("da", new String[]{"V\u00e6dderen", "Tyren", "Tvillingerne", "Krebsen", "L\u00f8ven", "Jomfruen", "V\u00e6gten", "Skorpionen", "Slangeb\u00e6reren", "Skytten", "Stenbukken", "Vandmanden", "Fiskene"});
        hashMap.put("de", new String[]{"Widder", "Stier", "Zwillinge", "Krebs", "L\u00f6we", "Jungfrau", "Waage", "Skorpion", "Schlangentr\u00e4ger", "Sch\u00fctze", "Steinbock", "Wassermann", "Fische"});
        hashMap.put("en", new String[]{"Ram", "Bull", "Twins", "Crab", "Lion", "Maiden", "Scales", "Scorpion", "Serpent-bearer", "Archer", "Capricorn", "Water-bearer", "Fish"});
        hashMap.put("es", new String[]{"Aries", "Tauro", "G\u00e9minis", "C\u00e1ncer", "Leo", "Virgo", "Libra", "Escorpio", "Ofiuco", "Sagitario", "Capricornio", "Acuario", "Piscis"});
        hashMap.put("fr", new String[]{"B\u00e9lier", "Taureau", "G\u00e9meaux", "Cancer", "Lion", "Vierge", "Balance", "Scorpion", "Serpentaire", "Sagittaire", "Capricorne", "Verseau", "Poissons"});
        hashMap.put("it", new String[]{"Ariete", "Toro", "Gemelli", "Cancro", "Leone", "Vergine", "Bilancia", "Scorpione", "Ofiuco", "Sagittario", "Capricorno", "Acquario", "Pesci"});
        hashMap.put("nl", new String[]{"Ram", "Stier", "Tweelingen", "Kreeft", "Leeuw", "Maagd", "Weegschaal", "Schorpioen", "Slangendrager", "Schutter", "Steenbok", "Waterman", "Vissen"});
        hashMap.put("ru", new String[]{"\u041e\u0432\u0435\u043d", "\u0422\u0435\u043b\u0435\u0446", "\u0411\u043b\u0438\u0437\u043d\u0435\u0446\u044b", "\u0420\u0430\u043a", "\u041b\u0435\u0432", "\u0414\u0435\u0432\u0430", "\u0412\u0435\u0441\u044b", "\u0421\u043a\u043e\u0440\u043f\u0438\u043e\u043d", "\u0417\u043c\u0435\u0435\u043d\u043e\u0441\u0435\u0446", "\u0421\u0442\u0440\u0435\u043b\u0435\u0446", "\u041a\u043e\u0437\u0435\u0440\u043e\u0433", "\u0412\u043e\u0434\u043e\u043b\u0435\u0439", "\u0420\u044b\u0431\u044b"});
        hashMap.put("tr", new String[]{"Ko\u00e7", "Bo\u011fa", "\u0130kizler", "Yenge\u00e7", "Aslan", "Ba\u015fak", "Terazi", "Akrep", "Ophiuchus", "Yay", "O\u011flak", "Kova", "Bal\u0131k"});
        LANG_TO_NAMES = Collections.unmodifiableMap(hashMap);
    }

    public static class Event
    implements ChronoCondition<Moment> {
        private final char body;
        private final Zodiac zodiac;
        private final boolean horoscope;

        private Event(char c, Zodiac zodiac, boolean bl) {
            if (c != 'S' && c != 'L') {
                throw new IllegalArgumentException("Unsupported celestial body: " + c);
            }
            if (zodiac == null) {
                throw new IllegalArgumentException("Celestial coordinates must be finite.");
            }
            if (bl && zodiac == OPHIUCHUS) {
                throw new IllegalArgumentException("Ophiuchus is not an astrological zodiac sign.");
            }
            this.body = c;
            this.zodiac = zodiac;
            this.horoscope = bl;
        }

        public Moment atMomentOfEntry(Moment moment) {
            Moment moment2 = this.atTime(moment, false, true);
            return this.atTime(moment2, false, false);
        }

        public Moment atMomentOfExit(Moment moment) {
            Moment moment2 = this.atTime(moment, true, true);
            return this.atTime(moment2, true, false);
        }

        @Override
        public boolean test(Moment moment) {
            double d;
            double d2;
            double d3;
            Moment moment2 = (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
            double d4 = JulianDay.ofEphemerisTime(moment2).getValue();
            double d5 = d3 = this.body == 'S' ? Zodiac.getSolarLongitude(d4) : Zodiac.getLunarLongitude(d4);
            if (this.horoscope) {
                d2 = this.getHoroscopeLongitude(false);
                d = this.getHoroscopeLongitude(true);
            } else {
                Zodiac zodiac = this.zodiac;
                Zodiac zodiac2 = zodiac.next();
                d2 = Zodiac.toEclipticAngle(moment2, zodiac.entry.getRightAscension(), zodiac.entry.getDeclination());
                d = Zodiac.toEclipticAngle(moment2, zodiac2.entry.getRightAscension(), zodiac2.entry.getDeclination());
            }
            if (d < d2) {
                d += 360.0;
                if (d3 < 180.0) {
                    d3 += 360.0;
                }
            }
            return d3 >= d2 && d3 < d;
        }

        static Event ofSign(char c, Zodiac zodiac) {
            return new Event(c, zodiac, true);
        }

        static Event ofConstellation(char c, Zodiac zodiac) {
            return new Event(c, zodiac, false);
        }

        private Zodiac getZodiac(boolean bl) {
            Zodiac zodiac = this.zodiac;
            if (bl) {
                zodiac = zodiac.next();
            }
            if (this.horoscope && zodiac == OPHIUCHUS) {
                zodiac = SAGITTARIUS;
            }
            return zodiac;
        }

        private int getHoroscopeLongitude(boolean bl) {
            Zodiac zodiac = this.getZodiac(bl);
            int n = zodiac.compareTo(OPHIUCHUS) < 0 ? 0 : -1;
            return (zodiac.ordinal() + n) * 30;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Moment atTime(Moment moment, boolean bl, boolean bl2) {
            double d;
            double d2;
            double d3;
            if (this.horoscope) {
                if (!bl2) return moment;
                d3 = this.getHoroscopeLongitude(bl);
            } else {
                Zodiac zodiac = this.getZodiac(bl);
                d3 = Zodiac.toEclipticAngle(moment, zodiac.entry.getRightAscension(), zodiac.entry.getDeclination());
            }
            double d4 = d2 = JulianDay.ofEphemerisTime(moment).getValue();
            if (this.body == 'S') {
                d = d3 - Zodiac.getSolarLongitude(d2);
                if (bl2) {
                    d = Event.modulo360(d);
                }
                d4 += d * 365.242189 / 360.0;
            } else {
                d = d3 - Zodiac.getLunarLongitude(d2);
                if (bl2) {
                    d = Event.modulo360(d);
                }
                d4 += d * 29.530588861 / 360.0;
            }
            d = Math.max(d2, d4 - 5.0);
            double d5 = d4 + 5.0;
            while (true) {
                double d6 = (d + d5) / 2.0;
                if (d5 - d < 1.0E-4) {
                    return (Moment)JulianDay.ofEphemerisTime(d6).toMoment().with(Moment.PRECISION, TimeUnit.SECONDS);
                }
                double d7 = (this.body == 'S' ? Zodiac.getSolarLongitude(d6) : Zodiac.getLunarLongitude(d6)) - d3;
                if (Event.modulo360(d7) < 180.0) {
                    d5 = d6;
                    continue;
                }
                d = d6;
            }
        }

        private static double modulo360(double d) {
            return d - 360.0 * Math.floor(d / 360.0);
        }
    }
}

