/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import net.time4j.calendar.astro.EquatorialCoordinates;

final class SkyPosition
implements EquatorialCoordinates {
    private final double ra;
    private final double dec;

    SkyPosition(double d, double d2) {
        if (Double.isNaN(d) || Double.isInfinite(d) || Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Not finite: " + d + "/" + d2);
        }
        this.ra = d;
        this.dec = d2;
    }

    @Override
    public double getRightAscension() {
        return this.ra;
    }

    @Override
    public double getDeclination() {
        return this.dec;
    }

    public boolean equals(Object object) {
        if (object instanceof SkyPosition) {
            SkyPosition skyPosition = (SkyPosition)object;
            return this.ra == skyPosition.ra && this.dec == skyPosition.dec;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.ra) + 37 * Double.hashCode(this.dec);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RA/Dec=[");
        stringBuilder.append(this.ra);
        stringBuilder.append(',');
        stringBuilder.append(this.dec);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

