/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import net.time4j.AbstractTimeElement;
import net.time4j.PlainTime;
import net.time4j.ProportionalElement;
import net.time4j.ProportionalFunction;
import net.time4j.RoundingOperator;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;

final class LongElement
extends AbstractTimeElement<Long>
implements ProportionalElement<Long, PlainTime> {
    static final ChronoElement<Long> DAY_OVERFLOW = new LongElement();
    private static final long serialVersionUID = 5930990958663061693L;
    private final transient Long defaultMin;
    private final transient Long defaultMax;
    private final transient ChronoFunction<ChronoEntity<?>, BigDecimal> rf;

    private LongElement() {
        this("DAY_OVERFLOW", Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private LongElement(String string, long l, long l2) {
        super(string);
        this.defaultMin = l;
        this.defaultMax = l2;
        this.rf = new ProportionalFunction(this, true);
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public Long getDefaultMinimum() {
        return this.defaultMin;
    }

    @Override
    public Long getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public ChronoFunction<ChronoEntity<?>, BigDecimal> ratio() {
        return this.rf;
    }

    @Override
    public ChronoOperator<PlainTime> roundedUp(int n) {
        return new RoundingOperator<PlainTime>(this, Boolean.TRUE, n);
    }

    @Override
    public ChronoOperator<PlainTime> roundedHalf(int n) {
        return new RoundingOperator<PlainTime>(this, null, n);
    }

    @Override
    public ChronoOperator<PlainTime> roundedDown(int n) {
        return new RoundingOperator<PlainTime>(this, Boolean.FALSE, n);
    }

    static LongElement create(String string, long l, long l2) {
        return new LongElement(string, l, l2);
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainTime.lookupElement(this.name());
        if (object == null) {
            if (this.name().equals("DAY_OVERFLOW")) {
                return DAY_OVERFLOW;
            }
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

