/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.Volume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.EphemeralVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PVCVolumeUtils;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class GenericEphemeralWorkspaceVolume
extends WorkspaceVolume
implements EphemeralVolume {
    private String storageClassName;
    private String requestsSize;
    private String accessModes;

    @DataBoundConstructor
    public GenericEphemeralWorkspaceVolume() {
    }

    @Override
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @DataBoundSetter
    public void setStorageClassName(String storageClassName) {
        this.storageClassName = Util.fixEmptyAndTrim((String)storageClassName);
    }

    @Override
    public String getRequestsSize() {
        return this.requestsSize;
    }

    @DataBoundSetter
    public void setRequestsSize(@CheckForNull String requestsSize) {
        this.requestsSize = Util.fixEmptyAndTrim((String)requestsSize);
    }

    @Override
    public String getAccessModes() {
        return this.accessModes;
    }

    @DataBoundSetter
    public void setAccessModes(String accessModes) {
        this.accessModes = accessModes;
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return this.buildEphemeralVolume(volumeName);
    }

    @Extension
    @Symbol(value={"genericEphemeralVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        @NonNull
        public String getDisplayName() {
            return "Generic Ephemeral Volume";
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public ListBoxModel doFillAccessModesItems() {
            return PVCVolumeUtils.ACCESS_MODES_BOX;
        }
    }
}

