/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class HostPathVolume
extends PodVolume {
    private String mountPath;
    private String hostPath;
    @CheckForNull
    private Boolean readOnly;

    @DataBoundConstructor
    public HostPathVolume(String hostPath, String mountPath, Boolean readOnly) {
        this.hostPath = hostPath;
        this.mountPath = mountPath;
        this.readOnly = readOnly;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeFluent.HostPathNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewHostPath().withPath(this.getHostPath())).endHostPath()).build();
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    public String getHostPath() {
        return this.hostPath;
    }

    @NonNull
    public Boolean getReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    public String toString() {
        return "HostPathVolume [mountPath=" + this.mountPath + ", hostPath=" + this.hostPath + "]";
    }

    @Extension
    @Symbol(value={"hostPathVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Host Path Volume";
        }
    }
}

