/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Objects;
import org.csanchez.jenkins.plugins.kubernetes.volumes.EphemeralVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PVCVolumeUtils;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class GenericEphemeralVolume
extends PodVolume
implements EphemeralVolume {
    private String storageClassName;
    private String requestsSize;
    private String accessModes;
    private String mountPath;

    @DataBoundConstructor
    public GenericEphemeralVolume() {
    }

    @Override
    @CheckForNull
    public String getAccessModes() {
        return this.accessModes;
    }

    @DataBoundSetter
    public void setAccessModes(@CheckForNull String accessModes) {
        this.accessModes = accessModes;
    }

    @Override
    @CheckForNull
    public String getRequestsSize() {
        return this.requestsSize;
    }

    @DataBoundSetter
    public void setRequestsSize(@CheckForNull String requestsSize) {
        this.requestsSize = Util.fixEmptyAndTrim((String)requestsSize);
    }

    @Override
    @CheckForNull
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @DataBoundSetter
    public void setStorageClassName(@CheckForNull String storageClassName) {
        this.storageClassName = Util.fixEmptyAndTrim((String)storageClassName);
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return this.buildEphemeralVolume(volumeName);
    }

    @DataBoundSetter
    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericEphemeralVolume that = (GenericEphemeralVolume)o;
        return Objects.equals(this.storageClassName, that.storageClassName) && Objects.equals(this.requestsSize, that.requestsSize) && Objects.equals(this.accessModes, that.accessModes) && Objects.equals(this.mountPath, that.mountPath);
    }

    public int hashCode() {
        return Objects.hash(this.storageClassName, this.requestsSize, this.accessModes, this.mountPath);
    }

    @Extension
    @Symbol(value={"genericEphemeralVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        @NonNull
        public String getDisplayName() {
            return "Generic ephemeral volume";
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public ListBoxModel doFillAccessModesItems() {
            return PVCVolumeUtils.ACCESS_MODES_BOX;
        }
    }
}

