/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFolderProperty;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateContext;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class PodTemplateStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateStepExecution.class.getName());
    private static final long serialVersionUID = -6139090518333729333L;
    private static final String NAME_FORMAT = "%s-%s";
    public static final String POD_ANNOTATION_BUILD_URL = "buildUrl";
    public static final String POD_ANNOTATION_RUN_URL = "runUrl";
    private static boolean VERBOSE = Boolean.parseBoolean(System.getProperty(PodTemplateStepExecution.class.getName() + ".verbose"));
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient PodTemplateStep step;
    private final String cloudName;
    private PodTemplate newTemplate = null;

    PodTemplateStepExecution(PodTemplateStep step, StepContext context) {
        super(context);
        this.step = step;
        this.cloudName = step.getCloud();
    }

    public boolean start() throws Exception {
        Object label;
        PodTemplateContext podTemplateContext;
        KubernetesCloud cloud = PodTemplateStepExecution.resolveCloud(this.cloudName);
        Run run = (Run)this.getContext().get(Run.class);
        if (cloud.isUsageRestricted()) {
            this.checkAccess(run, cloud);
        }
        String parentTemplates = (podTemplateContext = (PodTemplateContext)this.getContext().get(PodTemplateContext.class)) != null ? podTemplateContext.getName() : null;
        String podTemplateLabel = this.step.getLabel();
        if (podTemplateLabel == null) {
            String sanitized = PodTemplateUtils.sanitizeLabel(run.getExternalizableId()) + "-" + RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
            assert (PodTemplateUtils.validateLabel(sanitized)) : sanitized;
            label = sanitized;
        } else {
            label = podTemplateLabel;
        }
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        Object stepName = this.step.getName();
        if (stepName == null) {
            stepName = label;
        }
        String name = String.format(NAME_FORMAT, stepName, randString);
        String namespace = this.checkNamespace(cloud, podTemplateContext);
        this.newTemplate = new PodTemplate();
        this.newTemplate.setName(name);
        this.newTemplate.setNamespace(namespace);
        if (this.step.getInheritFrom() == null) {
            this.newTemplate.setInheritFrom(PodTemplateUtils.emptyToNull(parentTemplates));
        } else {
            this.newTemplate.setInheritFrom(PodTemplateUtils.emptyToNull(this.step.getInheritFrom()));
        }
        this.newTemplate.setInstanceCap(this.step.getInstanceCap());
        this.newTemplate.setIdleMinutes(this.step.getIdleMinutes());
        this.newTemplate.setSlaveConnectTimeout(this.step.getSlaveConnectTimeout());
        this.newTemplate.setLabel((String)label);
        this.newTemplate.setEnvVars(this.step.getEnvVars());
        this.newTemplate.setVolumes(this.step.getVolumes());
        if (this.step.getWorkspaceVolume() != null) {
            this.newTemplate.setWorkspaceVolume(this.step.getWorkspaceVolume());
        }
        this.newTemplate.setContainers(this.step.getContainers());
        this.newTemplate.setNodeSelector(this.step.getNodeSelector());
        this.newTemplate.setNodeUsageMode(this.step.getNodeUsageMode());
        this.newTemplate.setServiceAccount(this.step.getServiceAccount());
        this.newTemplate.setSchedulerName(this.step.getSchedulerName());
        this.newTemplate.setRunAsUser(this.step.getRunAsUser());
        this.newTemplate.setRunAsGroup(this.step.getRunAsGroup());
        if (this.step.getHostNetwork() != null) {
            this.newTemplate.setHostNetwork(this.step.getHostNetwork());
        }
        this.newTemplate.setAnnotations(this.step.getAnnotations());
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        this.newTemplate.setListener(listener);
        this.newTemplate.setYamlMergeStrategy(this.step.getYamlMergeStrategy());
        if (run != null) {
            this.newTemplate.setInheritYamlMergeStrategy(this.step.isInheritYamlMergeStrategy());
            String url = cloud.getJenkinsUrlOrNull();
            if (url != null) {
                this.newTemplate.getAnnotations().add(new PodAnnotation(POD_ANNOTATION_BUILD_URL, (String)url + run.getUrl()));
                this.newTemplate.getAnnotations().add(new PodAnnotation(POD_ANNOTATION_RUN_URL, run.getUrl()));
            }
            this.newTemplate.setRun(run);
        }
        this.newTemplate.setImagePullSecrets(this.step.getImagePullSecrets().stream().map(x -> new PodImagePullSecret((String)x)).collect(Collectors.toList()));
        this.newTemplate.setYaml(this.step.getYaml());
        if (this.step.isShowRawYamlSet()) {
            this.newTemplate.setShowRawYaml(this.step.isShowRawYaml());
        }
        this.newTemplate.setAgentInjection(this.step.isAgentInjection());
        this.newTemplate.setAgentContainer(this.step.getAgentContainer());
        this.newTemplate.setPodRetention(this.step.getPodRetention());
        if (this.step.getActiveDeadlineSeconds() != 0) {
            this.newTemplate.setActiveDeadlineSeconds(this.step.getActiveDeadlineSeconds());
        }
        for (ContainerTemplate container : this.newTemplate.getContainers()) {
            if (PodTemplateUtils.validateContainerName(container.getName())) continue;
            throw new AbortException(Messages.RFC1123_error(container.getName()));
        }
        Collection<String> errors = PodTemplateUtils.validateYamlContainerNames(this.newTemplate.getYamls());
        if (!errors.isEmpty()) {
            throw new AbortException(Messages.RFC1123_error(String.join((CharSequence)", ", errors)));
        }
        if (VERBOSE) {
            listener.getLogger().println("Registering template with id=" + this.newTemplate.getId() + ",label=" + this.newTemplate.getLabel());
        }
        cloud.addDynamicTemplate(this.newTemplate);
        BodyInvoker invoker = this.getContext().newBodyInvoker().withContexts(new Object[]{this.step, new PodTemplateContext(namespace, name)}).withCallback((BodyExecutionCallback)new PodTemplateCallback(this.newTemplate, this.cloudName));
        if (this.step.getLabel() == null) {
            invoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(Collections.singletonMap("POD_LABEL", label))));
        }
        invoker.start();
        return false;
    }

    @NonNull
    private static KubernetesCloud resolveCloud(String cloudName) throws AbortException {
        KubernetesCloud cloud;
        if (cloudName == null) {
            cloud = (KubernetesCloud)Jenkins.get().clouds.get(KubernetesCloud.class);
            if (cloud == null) {
                throw new AbortException("No Kubernetes cloud was found.");
            }
        } else {
            Cloud cl = Jenkins.get().getCloud(cloudName);
            if (cl == null) {
                throw new AbortException(String.format("Cloud does not exist: %s", cloudName));
            }
            if (!(cl instanceof KubernetesCloud)) {
                throw new AbortException(String.format("Cloud is not a Kubernetes cloud: %s (%s)", cloudName, cl.getClass().getName()));
            }
            cloud = (KubernetesCloud)cl;
        }
        return cloud;
    }

    private void checkAccess(Run<?, ?> run, KubernetesCloud kubernetesCloud) throws AbortException {
        Job job = run.getParent();
        ItemGroup parent = job.getParent();
        HashSet<String> allowedClouds = new HashSet<String>();
        KubernetesFolderProperty.collectAllowedClouds(allowedClouds, parent);
        if (!allowedClouds.contains(kubernetesCloud.name)) {
            throw new AbortException(String.format("Not authorized to use Kubernetes cloud: %s", this.step.getCloud()));
        }
    }

    private String checkNamespace(KubernetesCloud kubernetesCloud, @CheckForNull PodTemplateContext podTemplateContext) {
        String namespace = null;
        namespace = !PodTemplateUtils.isNullOrEmpty(this.step.getNamespace()) ? this.step.getNamespace() : (podTemplateContext != null && !PodTemplateUtils.isNullOrEmpty(podTemplateContext.getNamespace()) ? podTemplateContext.getNamespace() : kubernetesCloud.getNamespace());
        return namespace;
    }

    public void onResume() {
        try {
            KubernetesCloud cloud = PodTemplateStepExecution.resolveCloud(this.cloudName);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            this.newTemplate.setListener(listener);
            this.newTemplate.setRun((Run)this.getContext().get(Run.class));
            LOGGER.log(Level.FINE, "Re-registering template with id=" + this.newTemplate.getId() + " after resume");
            if (VERBOSE) {
                listener.getLogger().println("Re-registering template with id=" + this.newTemplate.getId() + ",label=" + this.newTemplate.getLabel() + " after resume");
            }
            cloud.addDynamicTemplate(this.newTemplate);
        }
        catch (AbortException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Unable to inject task listener", e);
        }
    }

    private static class PodTemplateCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6043919968776851324L;
        private final PodTemplate podTemplate;
        private final String cloudName;

        private PodTemplateCallback(PodTemplate podTemplate, String cloudName) {
            this.podTemplate = podTemplate;
            this.cloudName = cloudName;
        }

        protected void finished(StepContext context) throws Exception {
            try {
                KubernetesCloud cloud = PodTemplateStepExecution.resolveCloud(this.cloudName);
                LOGGER.log(Level.FINE, () -> "Removing pod template " + this.podTemplate.getName() + " from cloud " + cloud.name);
                cloud.removeDynamicTemplate(this.podTemplate);
            }
            catch (AbortException e) {
                LOGGER.log(Level.WARNING, e, () -> "Unable to resolve cloud for " + this.podTemplate.getName() + ". Maybe the cloud was removed while running the build?");
            }
        }
    }
}

