/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ContainerStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 5588861066775717487L;
    private final String name;
    private String shell;

    @DataBoundConstructor
    public ContainerStep(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setShell(String shell) {
        this.shell = Util.fixEmpty((String)shell);
    }

    public String getShell() {
        return this.shell;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ContainerStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "container";
        }

        public String getDisplayName() {
            return "Run build steps in a container";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Node.class, FilePath.class, TaskListener.class)));
        }
    }
}

