/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerLogStep;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class ContainerLogStepExecution
extends SynchronousNonBlockingStepExecution<String> {
    private static final long serialVersionUID = 5588861066775717487L;
    private static final Logger LOGGER = Logger.getLogger(ContainerLogStepExecution.class.getName());
    private final ContainerLogStep step;

    ContainerLogStepExecution(ContainerLogStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream logger() {
        TaskListener l = null;
        StepContext context = this.getContext();
        try {
            l = (TaskListener)context.get(TaskListener.class);
        }
        catch (IOException | InterruptedException x) {
            LOGGER.log(Level.WARNING, "Failed to find TaskListener in context");
        }
        finally {
            if (l == null) {
                l = new LogTaskListener(LOGGER, Level.FINE);
            }
        }
        return l.getLogger();
    }

    protected String run() throws Exception {
        boolean returnLog = this.step.isReturnLog();
        String containerName = this.step.getName();
        int tailingLines = this.step.getTailingLines();
        int sinceSeconds = this.step.getSinceSeconds();
        int limitBytes = this.step.getLimitBytes();
        try {
            LOGGER.log(Level.FINE, "Starting containerLog step.");
            KubernetesNodeContext nodeContext = new KubernetesNodeContext(this.getContext());
            String podName = nodeContext.getPodName();
            ContainerResource containerResource = (ContainerResource)nodeContext.getPodResource().inContainer((Object)containerName);
            ContainerResource limited = limitBytes > 0 ? containerResource.limitBytes(limitBytes) : containerResource;
            ContainerResource since = sinceSeconds > 0 ? limited.sinceSeconds(sinceSeconds) : limited;
            String log = (tailingLines > 0 ? since.tailingLines(tailingLines) : since).getLog();
            if (returnLog) {
                return log;
            }
            this.logger().println("> start log of container '" + containerName + "' in pod '" + podName + "'");
            this.logger().print(log);
            if (log.length() > 0 && log.charAt(log.length() - 1) != '\n') {
                this.logger().println();
            }
            this.logger().println("> end log of container '" + containerName + "' in pod '" + podName + "'");
            return "";
        }
        catch (InterruptedException e) {
            this.logger().println("Interrupted while getting logs of container");
            LOGGER.log(Level.FINE, "interrupted while getting logs of container {1}", containerName);
            return "";
        }
        catch (Exception e) {
            String message = "Failed to get logs for container";
            this.logger().println(message);
            LOGGER.log(Level.WARNING, message, e);
            return "";
        }
    }

    public void stop(Throwable cause) throws Exception {
        LOGGER.log(Level.FINE, "Stopping container log step.");
        super.stop(cause);
    }
}

