/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.slaves.Cloud;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.access.AccessDeniedException;

public class NonConfigurableKubernetesCloud
extends KubernetesCloud {
    public NonConfigurableKubernetesCloud(@NonNull String name, @NonNull KubernetesCloud source) {
        super(name, source);
    }

    @Override
    public void replaceTemplate(PodTemplate oldTemplate, PodTemplate newTemplate) {
    }

    @Override
    public void addTemplate(PodTemplate template) {
    }

    @Override
    public void removeTemplate(PodTemplate template) {
    }

    @Override
    public boolean hasManagePermission() {
        return false;
    }

    @Override
    public void checkManagePermission() throws AccessDeniedException {
    }

    @Override
    public Cloud reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        return ((DescriptorImpl)((Object)DescriptorImpl.class.cast(this.getDescriptor()))).newInstance(req, form);
    }

    @Override
    @NonNull
    public List<PodTemplate> getTemplates() {
        return super.getTemplates().stream().peek(podTemplate -> podTemplate.setReadonlyFromUi(true)).collect(Collectors.toList());
    }

    @Extension
    public static class DescriptorImpl
    extends KubernetesCloud.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return Messages.NonConfigurableKubernetesCloud_displayName();
        }

        public boolean configure(StaplerRequest2 request, JSONObject object) throws Descriptor.FormException {
            return true;
        }

        public Cloud newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (req != null) {
                String cloudName = req.getParameter("cloudName");
                return Jenkins.get().getCloud(cloudName);
            }
            throw new IllegalStateException("Expecting req to be non-null");
        }
    }

    @Extension
    public static class FilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            return !(descriptor instanceof DescriptorImpl);
        }
    }
}

