/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Engine;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.IOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.api.Metrics;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputerFactory;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesLauncher;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.PodUtils;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesSlave
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(KubernetesSlave.class.getName());
    private static final Integer DISCONNECTION_TIMEOUT = Integer.getInteger(KubernetesSlave.class.getName() + ".disconnectionTimeout", 5);
    private static final long serialVersionUID = -8642936855413034232L;
    private static final String DEFAULT_AGENT_PREFIX = "jenkins-agent";
    private static final ResourceBundleHolder HOLDER = ResourceBundleHolder.get(Messages.class);
    private final String cloudName;
    private String namespace;
    @NonNull
    private String podTemplateId;
    private transient PodTemplate template;
    private transient Set<Queue.Executable> executables = new HashSet<Queue.Executable>();
    @CheckForNull
    private transient Pod pod;
    private String remoteFS;

    @NonNull
    public PodTemplate getTemplate() throws IllegalStateException {
        PodTemplate template = this.getTemplateOrNull();
        if (template == null) {
            throw new IllegalStateException("Unable to resolve pod template from id=" + this.podTemplateId);
        }
        return template;
    }

    @NonNull
    public String getTemplateId() {
        return this.podTemplateId;
    }

    @CheckForNull
    public PodTemplate getTemplateOrNull() {
        if (this.template == null) {
            this.template = this.getKubernetesCloud().getTemplateById(this.podTemplateId);
        }
        return this.template;
    }

    @NonNull
    public TaskListener getRunListener() {
        TaskListener listener;
        PodTemplate podTemplate = this.getTemplateOrNull();
        if (podTemplate != null && (listener = podTemplate.getListenerOrNull()) != null) {
            return listener;
        }
        Computer c = this.toComputer();
        if (c != null) {
            for (Executor executor : c.getExecutors()) {
                FlowExecutionOwner flowExecutionOwner;
                Queue.Executable parentExecutable;
                Queue.Executable executable = executor.getCurrentExecutable();
                if (executable == null || !((parentExecutable = executable.getParentExecutable()) instanceof FlowExecutionOwner.Executable) || (flowExecutionOwner = ((FlowExecutionOwner.Executable)parentExecutable).asFlowExecutionOwner()) == null) continue;
                try {
                    return flowExecutionOwner.getListener();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }
        }
        return TaskListener.NULL;
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, String labelStr) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, labelStr, (RetentionStrategy)new OnceRetentionStrategy(cloud.getRetentionTimeout()));
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, Label label) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, label.toString(), (RetentionStrategy)new OnceRetentionStrategy(cloud.getRetentionTimeout()));
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, String labelStr, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, labelStr, rs);
    }

    @Deprecated
    @DataBoundConstructor
    public KubernetesSlave(PodTemplate template, String nodeDescription, String cloudName, String labelStr, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        this(KubernetesSlave.getSlaveName(template), template, nodeDescription, cloudName, labelStr, (ComputerLauncher)new KubernetesLauncher(), rs);
    }

    protected KubernetesSlave(String name, @NonNull PodTemplate template, String nodeDescription, String cloudName, String labelStr, ComputerLauncher computerLauncher, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        super(name, null, computerLauncher);
        this.setNodeDescription(nodeDescription);
        this.setNumExecutors(1);
        this.setMode(template.getNodeUsageMode() != null ? template.getNodeUsageMode() : Node.Mode.NORMAL);
        this.setLabelString(labelStr);
        this.setRetentionStrategy(rs);
        this.setNodeProperties((List)((Object)template.getNodeProperties()));
        this.cloudName = cloudName;
        this.template = template;
        this.podTemplateId = template.getId();
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void setNamespace(@NonNull String namespace) {
        this.namespace = namespace;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public String getPodName() {
        return PodTemplateUtils.substituteEnv(this.getNodeName());
    }

    @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="Naming confusion with a getRemoteFs method, but the latter is deprecated.")
    public String getRemoteFS() {
        Optional<Container> optionalJnlp;
        Optional<Pod> optionalPod;
        if (this.remoteFS == null && (optionalPod = this.getPod()).isPresent() && (optionalJnlp = optionalPod.get().getSpec().getContainers().stream().filter(c -> "jnlp".equals(c.getName())).findFirst()).isPresent()) {
            this.remoteFS = StringUtils.defaultIfBlank((String)optionalJnlp.get().getWorkingDir(), (String)"/home/jenkins/agent");
        }
        return Util.fixNull((String)this.remoteFS);
    }

    @CheckForNull
    public FilePath getRootPath() {
        SlaveComputer computer = this.getComputer();
        if (computer == null) {
            return null;
        }
        return this.createPath(StringUtils.defaultString((String)computer.getAbsoluteRemoteFs(), (String)this.getRemoteFS()));
    }

    @Deprecated
    public Cloud getCloud() {
        return Jenkins.getInstance().getCloud(this.getCloudName());
    }

    public Optional<Pod> getPod() {
        Pod p = this.pod;
        if (p == null) {
            try {
                p = (Pod)this.getKubernetesCloud().getPodResource(this.getNamespace(), this.getPodName()).get();
                if (p != null) {
                    this.assignPod(p);
                    return Optional.of(p);
                }
                return Optional.empty();
            }
            catch (IOException | IllegalStateException | KubernetesAuthException e) {
                LOGGER.log(Level.WARNING, e, () -> String.format("Failed to connect to cloud %s to get pod %s/%s", this.getCloudName(), this.getNamespace(), this.getPodName()));
                return Optional.empty();
            }
        }
        return Optional.of(p);
    }

    @NonNull
    public KubernetesCloud getKubernetesCloud() {
        return KubernetesSlave.getKubernetesCloud(this.getCloudName());
    }

    private static KubernetesCloud getKubernetesCloud(String cloudName) {
        Cloud cloud = Jenkins.get().getCloud(cloudName);
        if (cloud instanceof KubernetesCloud) {
            return (KubernetesCloud)cloud;
        }
        if (cloud == null) {
            throw new IllegalStateException("No such cloud " + cloudName);
        }
        throw new IllegalStateException(KubernetesSlave.class.getName() + " can be launched only by instances of " + KubernetesCloud.class.getName() + ". Cloud is " + cloud.getClass().getName());
    }

    static String getSlaveName(PodTemplate template) {
        String slaveName;
        String name = template.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = DEFAULT_AGENT_PREFIX;
        }
        if (!PodUtils.isValidName(slaveName = PodUtils.createNameWithRandomSuffix(name))) {
            slaveName = PodUtils.createNameWithRandomSuffix(DEFAULT_AGENT_PREFIX);
        }
        return slaveName;
    }

    public KubernetesComputer createComputer() {
        return KubernetesComputerFactory.createInstance(this);
    }

    public PodRetention getPodRetention(KubernetesCloud cloud) {
        PodRetention retentionPolicy = cloud.getPodRetention();
        PodTemplate template = this.getTemplateOrNull();
        if (template != null) {
            PodRetention pr;
            retentionPolicy = pr = template.getPodRetention();
        }
        return retentionPolicy;
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        String msg;
        KubernetesClient client;
        KubernetesCloud cloud;
        LOGGER.log(Level.INFO, "Terminating Kubernetes instance for agent {0}", this.name);
        try {
            cloud = this.getKubernetesCloud();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(listener.fatalError("Unable to terminate agent. Cloud may have been removed. There may be leftover resources on the Kubernetes cluster."));
            LOGGER.log(Level.SEVERE, String.format("Unable to terminate agent %s. Cloud may have been removed. There may be leftover resources on the Kubernetes cluster.", this.name));
            return;
        }
        try {
            client = cloud.connect();
        }
        catch (IOException | KubernetesAuthException e) {
            String msg2 = String.format("Failed to connect to cloud %s. There may be leftover resources on the Kubernetes cluster.", this.getCloudName());
            e.printStackTrace(listener.fatalError(msg2));
            LOGGER.log(Level.SEVERE, msg2);
            return;
        }
        boolean deletePod = this.getPodRetention(cloud).shouldDeletePod(cloud, () -> (Pod)KubernetesCloud.getPodResource(client, this.getNamespace(), this.name).get());
        Computer computer = this.toComputer();
        if (computer == null) {
            String msg3 = String.format("Computer for agent is null: %s", this.name);
            LOGGER.log(Level.SEVERE, msg3);
            listener.fatalError(msg3);
            return;
        }
        VirtualChannel ch = computer.getChannel();
        if (ch != null) {
            Future disconnectorFuture = ch.callAsync((Callable)new SlaveDisconnector());
            try {
                disconnectorFuture.get(DISCONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                String msg4 = String.format("Ignoring error sending order to not reconnect agent %s: %s", this.name, e.getMessage());
                LOGGER.log(Level.INFO, msg4, e);
            }
        }
        if (this.getCloudName() == null) {
            msg = String.format("Cloud name is not set for agent, can't terminate: %s", this.name);
            LOGGER.log(Level.SEVERE, msg);
            listener.fatalError(msg);
            return;
        }
        if (deletePod) {
            this.deleteSlavePod(listener, client);
            Metrics.metricRegistry().counter("kubernetes.cloud.pods.terminated").inc();
        } else {
            LOGGER.log(Level.WARNING, "Agent pod {0} was not deleted due to retention policy {1}.", new Object[]{this.name, this.getPodRetention(cloud)});
        }
        msg = String.format("Disconnected computer %s", this.name);
        LOGGER.log(Level.INFO, msg);
        listener.getLogger().println(msg);
    }

    private void deleteSlavePod(TaskListener listener, KubernetesClient client) {
        if (this.getNamespace() == null) {
            return;
        }
        try {
            boolean deleted;
            boolean bl = deleted = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.getNamespace())).withName(this.name)).delete().size() == 1;
            if (!deleted) {
                String msg = String.format("Failed to delete pod for agent %s/%s: not found", this.getNamespace(), this.name);
                LOGGER.log(Level.WARNING, msg);
                listener.error(msg);
                return;
            }
        }
        catch (KubernetesClientException e) {
            String msg = String.format("Failed to delete pod for agent %s/%s: %s", this.getNamespace(), this.name, e.getMessage());
            LOGGER.log(Level.WARNING, msg, e);
            listener.error(msg);
            return;
        }
        String msg = String.format("Terminated Kubernetes instance for agent %s/%s", this.getNamespace(), this.name);
        LOGGER.log(Level.INFO, msg);
        listener.getLogger().println(msg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesSlave that = (KubernetesSlave)((Object)o);
        return this.cloudName.equals(that.cloudName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cloudName);
    }

    public Launcher createLauncher(TaskListener listener) {
        Queue.Executable currentExecutable;
        Executor executor;
        Launcher launcher = super.createLauncher(listener);
        if (this.template != null && (executor = Executor.currentExecutor()) != null && (currentExecutable = executor.getCurrentExecutable()) != null && this.executables.add(currentExecutable)) {
            listener.getLogger().println(Messages.KubernetesSlave_AgentIsProvisionedFromTemplate(ModelHyperlinkNote.encodeTo((String)("/computer/" + this.getNodeName()), (String)this.getNodeName()), this.template.getName()));
            this.printAgentDescription(listener);
            this.checkHomeAndWarnIfNeeded(listener);
        }
        return launcher;
    }

    void assignPod(@CheckForNull Pod pod) {
        this.pod = pod;
    }

    private void printAgentDescription(TaskListener listener) {
        if (this.pod != null && this.template.isShowRawYaml()) {
            listener.getLogger().println(this.podAsYaml());
        }
    }

    private String podAsYaml() {
        String x = Serialization.asYaml((Object)this.pod);
        Computer computer = this.toComputer();
        if (computer instanceof SlaveComputer) {
            SlaveComputer sc = (SlaveComputer)computer;
            return x.replaceAll(sc.getJnlpMac(), "********");
        }
        return x;
    }

    private void checkHomeAndWarnIfNeeded(TaskListener listener) {
        try {
            String home;
            Computer computer = this.toComputer();
            if (computer != null && "/".equals(home = (String)computer.getEnvironment().get((Object)"HOME"))) {
                listener.getLogger().println(Messages.KubernetesSlave_HomeWarning());
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(listener.error("[WARNING] Unable to retrieve HOME environment variable"));
        }
    }

    protected Object readResolve() {
        KubernetesSlave ks = (KubernetesSlave)((Object)super.readResolve());
        ks.executables = new HashSet<Queue.Executable>();
        return ks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void annotateTtl(TaskListener listener) {
        try {
            KubernetesCloud kubernetesCloud = this.getKubernetesCloud();
            Optional.ofNullable(kubernetesCloud.getGarbageCollection()).ifPresent(gc -> {
                String ns = this.getNamespace();
                String name = this.getPodName();
                Instant l = Instant.now();
                try {
                    kubernetesCloud.getPodResource(ns, name).patch("{\"metadata\":{\"annotations\":{\"kubernetes.jenkins.io/last-refresh\":\"" + l.toEpochMilli() + "\"}}}");
                }
                catch (KubernetesAuthException e) {
                    e.printStackTrace(listener.error("Failed to authenticate to Kubernetes cluster"));
                }
                catch (IOException e) {
                    e.printStackTrace(listener.error("Failed to connect to Kubernetes cluster"));
                }
                listener.getLogger().println("Annotated agent pod " + ns + "/" + name + " with TTL");
                LOGGER.log(Level.FINE, () -> "Annotated agent pod " + ns + "/" + name + " with TTL");
                try {
                    this.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Failed to save");
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace(listener.error("Failed to annotate agent pod with TTL"));
        }
    }

    private static class SlaveDisconnector
    extends MasterToSlaveCallable<Void, IOException> {
        private static final long serialVersionUID = 8683427258340193283L;
        private static final Logger LOGGER = Logger.getLogger(SlaveDisconnector.class.getName());

        private SlaveDisconnector() {
        }

        public Void call() throws IOException {
            Engine e = Engine.current();
            if (e == null) {
                return null;
            }
            e.setNoReconnect(true);
            LOGGER.log(Level.INFO, "Disabled agent engine reconnects.");
            return null;
        }
    }

    public static class Builder {
        private String name;
        private String nodeDescription;
        private PodTemplate podTemplate;
        private KubernetesCloud cloud;
        private String label;
        private ComputerLauncher computerLauncher;
        private RetentionStrategy retentionStrategy;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public Builder podTemplate(PodTemplate podTemplate) {
            this.podTemplate = podTemplate;
            return this;
        }

        public Builder cloud(KubernetesCloud cloud) {
            this.cloud = cloud;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder computerLauncher(ComputerLauncher computerLauncher) {
            this.computerLauncher = computerLauncher;
            return this;
        }

        public Builder retentionStrategy(RetentionStrategy retentionStrategy) {
            this.retentionStrategy = retentionStrategy;
            return this;
        }

        private static RetentionStrategy determineRetentionStrategy(@NonNull KubernetesCloud cloud, @NonNull PodTemplate podTemplate) {
            if (podTemplate.getIdleMinutes() == 0) {
                return new OnceRetentionStrategy(cloud.getRetentionTimeout());
            }
            return new CloudRetentionStrategy(podTemplate.getIdleMinutes());
        }

        @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="False positive. https://github.com/spotbugs/spotbugs/issues/567")
        public KubernetesSlave build() throws IOException, Descriptor.FormException {
            Validate.notNull((Object)this.podTemplate);
            Validate.notNull((Object)this.cloud);
            return new KubernetesSlave(this.name == null ? KubernetesSlave.getSlaveName(this.podTemplate) : this.name, this.podTemplate, this.nodeDescription == null ? this.podTemplate.getName() : this.nodeDescription, this.cloud.name, this.label == null ? this.podTemplate.getLabel() : this.label, this.decorateLauncher(this.cloud, (ComputerLauncher)(this.computerLauncher == null ? new KubernetesLauncher(this.cloud.getJenkinsTunnel(), null) : this.computerLauncher)), this.retentionStrategy == null ? Builder.determineRetentionStrategy(this.cloud, this.podTemplate) : this.retentionStrategy);
        }

        private ComputerLauncher decorateLauncher(@NonNull KubernetesCloud cloud, @NonNull ComputerLauncher launcher) {
            if (launcher instanceof KubernetesLauncher) {
                ((KubernetesLauncher)launcher).setWebSocket(cloud.isWebSocket());
            }
            return launcher;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Kubernetes Agent";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

