/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.slaves.Cloud;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class KubernetesFolderProperty
extends AbstractFolderProperty<AbstractFolder<?>> {
    private static final String PREFIX_USAGE_PERMISSION = "usage-permission-";
    private List<String> permittedClouds = new ArrayList<String>();

    @DataBoundConstructor
    public KubernetesFolderProperty() {
    }

    @DataBoundSetter
    public void setPermittedClouds(Collection<String> permittedClouds) {
        this.permittedClouds = permittedClouds == null ? Collections.emptyList() : new ArrayList<String>(permittedClouds);
    }

    public Collection<String> getPermittedClouds() {
        return this.permittedClouds == null ? Collections.emptyList() : Collections.unmodifiableList(this.permittedClouds);
    }

    private static Set<String> getInheritedClouds(ItemGroup parent) {
        HashSet<String> inheritedPermissions = new HashSet<String>();
        KubernetesFolderProperty.collectAllowedClouds(inheritedPermissions, parent);
        return inheritedPermissions;
    }

    public static boolean isAllowed(KubernetesSlave agent, Job job) {
        ItemGroup parent = job.getParent();
        HashSet<String> allowedClouds = new HashSet<String>();
        KubernetesCloud targetCloud = agent.getKubernetesCloud();
        if (targetCloud.isUsageRestricted()) {
            KubernetesFolderProperty.collectAllowedClouds(allowedClouds, parent);
            return allowedClouds.contains(targetCloud.name);
        }
        return true;
    }

    public AbstractFolderProperty<?> reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        if (!KubernetesFolderProperty.userHasAdministerPermission()) {
            return this;
        }
        if (form == null) {
            return null;
        }
        HashSet<String> formCloudNames = new HashSet<String>();
        if (!form.has("permittedClouds")) {
            form.names().stream().filter(x -> form.getBoolean(x.toString())).forEach(x -> formCloudNames.add(x.toString().replace(PREFIX_USAGE_PERMISSION, "")));
        } else {
            JSONArray clouds = form.optJSONArray("permittedClouds");
            if (clouds != null) {
                formCloudNames.addAll(clouds.stream().map(x -> x.toString()).collect(Collectors.toSet()));
            } else {
                formCloudNames.add(form.getString("permittedClouds"));
            }
        }
        this.setPermittedClouds(formCloudNames);
        return this;
    }

    public static void collectAllowedClouds(Set<String> allowedClouds, ItemGroup<?> itemGroup) {
        if (itemGroup instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)itemGroup;
            KubernetesFolderProperty kubernetesFolderProperty = (KubernetesFolderProperty)folder.getProperties().get(KubernetesFolderProperty.class);
            if (kubernetesFolderProperty != null) {
                allowedClouds.addAll(kubernetesFolderProperty.getPermittedClouds());
            }
            KubernetesFolderProperty.collectAllowedClouds(allowedClouds, folder.getParent());
        }
    }

    private static List<KubernetesCloud> getUsageRestrictedKubernetesClouds() {
        List<KubernetesCloud> clouds = Jenkins.get().clouds.getAll(KubernetesCloud.class).stream().filter(KubernetesCloud::isUsageRestricted).collect(Collectors.toList());
        clouds.sort(Comparator.comparing(o -> o.name));
        return clouds;
    }

    private static boolean userHasAdministerPermission() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private static boolean isUsageRestrictedKubernetesCloud(Cloud cloud) {
        if (cloud instanceof KubernetesCloud) {
            return ((KubernetesCloud)cloud).isUsageRestricted();
        }
        return false;
    }

    @Extension
    @Symbol(value={"kubernetes"})
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.KubernetesFolderProperty_displayName();
        }

        @Restricted(value={DoNotUse.class})
        public List<UsagePermission> getEffectivePermissions() {
            Set<String> inheritedClouds = KubernetesFolderProperty.getInheritedClouds(((AbstractFolder)Stapler.getCurrentRequest2().findAncestorObject(AbstractFolder.class)).getParent());
            List<UsagePermission> ps = KubernetesFolderProperty.getUsageRestrictedKubernetesClouds().stream().map(cloud -> new UsagePermission(cloud.name, inheritedClouds.contains(cloud.name), inheritedClouds.contains(cloud.name))).collect(Collectors.toList());
            if (!KubernetesFolderProperty.userHasAdministerPermission()) {
                ps = ps.stream().filter(UsagePermission::isGranted).collect(Collectors.toList());
            }
            return ps;
        }
    }

    public static class UsagePermission {
        private boolean granted;
        private boolean inherited;
        private String name;

        public UsagePermission(String name, boolean granted, boolean inherited) {
            this.name = name;
            this.granted = granted;
            this.inherited = inherited;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadonly() {
            return !KubernetesFolderProperty.userHasAdministerPermission() || this.isInherited();
        }
    }
}

