/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.csanchez.jenkins.plugins.kubernetes.InProvisioning;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;

@Extension
public class DefaultInProvisioning
extends InProvisioning {
    private static final Logger LOGGER = Logger.getLogger(DefaultInProvisioning.class.getName());

    private static boolean isNotAcceptingTasks(Node n) {
        Computer computer = n.toComputer();
        return computer != null && (computer.isLaunchSupported() || !n.isAcceptingTasks());
    }

    @Override
    public Set<String> getInProvisioning(@CheckForNull Label label) {
        if (label != null) {
            return label.getNodes().stream().filter(KubernetesSlave.class::isInstance).filter(DefaultInProvisioning::isNotAcceptingTasks).map(Node::getNodeName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

