/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateSource;

@Extension
public class PodTemplateMap {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateMap.class.getName());
    private Map<String, List<PodTemplate>> map = new CopyOnWriteMap.Hash();

    public static PodTemplateMap get() {
        return (PodTemplateMap)ExtensionList.lookupSingleton(PodTemplateMap.class);
    }

    @NonNull
    public List<PodTemplate> getTemplates(@NonNull KubernetesCloud cloud) {
        return Collections.unmodifiableList(this.getOrCreateTemplateList(cloud));
    }

    private List<PodTemplate> getOrCreateTemplateList(@NonNull KubernetesCloud cloud) {
        CopyOnWriteArrayList podTemplates = this.map.get(cloud.name);
        return podTemplates == null ? new CopyOnWriteArrayList() : podTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplate(@NonNull KubernetesCloud cloud, @NonNull PodTemplate podTemplate) {
        Map<String, List<PodTemplate>> map = this.map;
        synchronized (map) {
            LOGGER.log(Level.FINE, "Registering template with id=" + podTemplate.getId() + " to kubernetes cloud " + cloud.name);
            List<PodTemplate> list = this.getOrCreateTemplateList(cloud);
            list.add(podTemplate);
            this.map.put(cloud.name, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(@NonNull KubernetesCloud cloud, @NonNull PodTemplate podTemplate) {
        Map<String, List<PodTemplate>> map = this.map;
        synchronized (map) {
            LOGGER.log(Level.FINE, "Unregistering template with id=" + podTemplate.getId() + " from kubernetes cloud " + cloud.name);
            this.getOrCreateTemplateList(cloud).remove(podTemplate);
        }
    }

    @Extension
    public static class PodTemplateSourceImpl
    extends PodTemplateSource {
        @Override
        @NonNull
        public List<PodTemplate> getList(@NonNull KubernetesCloud cloud) {
            return PodTemplateMap.get().getTemplates(cloud);
        }
    }
}

