/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Node;
import hudson.model.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.api.Metrics;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public final class KubernetesProvisioningLimits {
    private static final Logger LOGGER = Logger.getLogger(KubernetesProvisioningLimits.class.getName());
    private final AtomicBoolean init = new AtomicBoolean();
    private final ConcurrentMap<String, Integer> podTemplateCounts = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, Integer> cloudCounts = new ConcurrentHashMap<String, Integer>();

    private boolean initInstance() {
        if (this.init.compareAndSet(false, true)) {
            Queue.withLock(() -> {
                KubernetesProvisioningLimits kubernetesProvisioningLimits = this;
                synchronized (kubernetesProvisioningLimits) {
                    Jenkins.get().getNodes().stream().filter(KubernetesSlave.class::isInstance).map(KubernetesSlave.class::cast).forEach(node -> {
                        this.cloudCounts.put(node.getCloudName(), this.getGlobalCount(node.getCloudName()) + node.getNumExecutors());
                        this.podTemplateCounts.put(node.getTemplateId(), this.getPodTemplateCount(node.getTemplateId()) + node.getNumExecutors());
                    });
                }
            });
            return false;
        }
        return true;
    }

    public static KubernetesProvisioningLimits get() {
        return (KubernetesProvisioningLimits)ExtensionList.lookupSingleton(KubernetesProvisioningLimits.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(@NonNull KubernetesCloud cloud, @NonNull PodTemplate podTemplate, int numExecutors) {
        this.initInstance();
        KubernetesProvisioningLimits kubernetesProvisioningLimits = this;
        synchronized (kubernetesProvisioningLimits) {
            int newGlobalCount = this.getGlobalCount(cloud.name) + numExecutors;
            if (newGlobalCount <= cloud.getContainerCap()) {
                int newPodTemplateCount = this.getPodTemplateCount(podTemplate.getId()) + numExecutors;
                if (newPodTemplateCount <= podTemplate.getInstanceCap()) {
                    this.cloudCounts.put(cloud.name, newGlobalCount);
                    LOGGER.log(Level.FINEST, () -> cloud.name + " global limit: " + newGlobalCount + "/" + cloud.getContainerCap());
                    this.podTemplateCounts.put(podTemplate.getId(), newPodTemplateCount);
                    LOGGER.log(Level.FINEST, () -> podTemplate.getName() + " template limit: " + newPodTemplateCount + "/" + podTemplate.getInstanceCap());
                    return true;
                }
                LOGGER.log(Level.FINEST, () -> podTemplate.getName() + " template limit reached: " + this.getPodTemplateCount(podTemplate.getId()) + "/" + podTemplate.getInstanceCap() + ". Cannot add " + numExecutors + " more!");
                Metrics.metricRegistry().counter("kubernetes.cloud.provision.reached.pod.cap").inc();
            } else {
                LOGGER.log(Level.FINEST, () -> cloud.name + " global limit reached: " + this.getGlobalCount(cloud.name) + "/" + cloud.getContainerCap() + ". Cannot add " + numExecutors + " more!");
                Metrics.metricRegistry().counter("kubernetes.cloud.provision.reached.global.cap").inc();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull KubernetesCloud cloud, @NonNull PodTemplate podTemplate, int numExecutors) {
        if (this.initInstance()) {
            KubernetesProvisioningLimits kubernetesProvisioningLimits = this;
            synchronized (kubernetesProvisioningLimits) {
                int newGlobalCount = this.getGlobalCount(cloud.name) - numExecutors;
                if (newGlobalCount < 0) {
                    LOGGER.log(Level.WARNING, "Global count for " + cloud.name + " went below zero. There is likely a bug in kubernetes-plugin");
                }
                this.cloudCounts.put(cloud.name, Math.max(0, newGlobalCount));
                LOGGER.log(Level.FINEST, () -> cloud.name + " global limit: " + Math.max(0, newGlobalCount) + "/" + cloud.getContainerCap());
                int newPodTemplateCount = this.getPodTemplateCount(podTemplate.getId()) - numExecutors;
                if (newPodTemplateCount < 0) {
                    LOGGER.log(Level.WARNING, "Pod template count for " + podTemplate.getName() + " went below zero. There is likely a bug in kubernetes-plugin");
                }
                this.podTemplateCounts.put(podTemplate.getId(), Math.max(0, newPodTemplateCount));
                LOGGER.log(Level.FINEST, () -> podTemplate.getName() + " template limit: " + Math.max(0, newPodTemplateCount) + "/" + podTemplate.getInstanceCap());
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    int getGlobalCount(String cloudName) {
        return this.cloudCounts.getOrDefault(cloudName, 0);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    int getPodTemplateCount(String podTemplate) {
        return this.podTemplateCounts.getOrDefault(podTemplate, 0);
    }

    @Extension
    public static class NodeListenerImpl
    extends NodeListener {
        protected void onDeleted(@NonNull Node node) {
            if (node instanceof KubernetesSlave) {
                KubernetesProvisioningLimits instance = KubernetesProvisioningLimits.get();
                KubernetesSlave kubernetesNode = (KubernetesSlave)node;
                PodTemplate template = kubernetesNode.getTemplateOrNull();
                if (template != null) {
                    instance.unregister(kubernetesNode.getKubernetesCloud(), template, node.getNumExecutors());
                }
            }
        }
    }
}

