/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.watch;

import hudson.model.Node;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.util.Optional;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;

public class PodStatusEventHandler
implements ResourceEventHandler<Pod> {
    private static final Logger LOGGER = Logger.getLogger(PodStatusEventHandler.class.getName());

    public void onUpdate(Pod unused, Pod pod) {
        Optional<Node> found = Jenkins.get().getNodes().stream().filter(n -> n.getNodeName().equals(pod.getMetadata().getName())).findFirst();
        if (found.isPresent()) {
            StringBuilder sb = new StringBuilder();
            pod.getStatus().getContainerStatuses().forEach(s -> sb.append(this.formatContainerStatus((ContainerStatus)s)));
            pod.getStatus().getConditions().forEach(c -> sb.append(this.formatPodStatus((PodCondition)c, pod.getStatus().getPhase(), sb)));
            if (!sb.toString().isEmpty()) {
                ((KubernetesSlave)found.get()).getRunListener().getLogger().println("[PodInfo] " + pod.getMetadata().getNamespace() + "/" + pod.getMetadata().getName() + String.valueOf(sb));
            }
        } else {
            LOGGER.fine(() -> "Event received for non-existent node: [" + pod.getMetadata().getName() + "]");
        }
    }

    private String formatPodStatus(PodCondition c, String phase, StringBuilder sb) {
        if (c.getReason() == null) {
            return "";
        }
        String message = c.getMessage();
        String formatted = String.format("%n\tPod [%s][%s] %s", phase, c.getReason(), message != null ? message : "No message");
        return sb.indexOf(formatted) == -1 ? formatted : "";
    }

    private String formatContainerStatus(ContainerStatus s) {
        String message;
        ContainerState state = s.getState();
        if (state.getRunning() != null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%n\tContainer [%s]", s.getName()));
        if (state.getTerminated() != null) {
            message = state.getTerminated().getMessage();
            sb.append(String.format(" terminated [%s] %s", state.getTerminated().getReason(), message != null ? message : "No message"));
        }
        if (state.getWaiting() != null) {
            message = state.getWaiting().getMessage();
            sb.append(String.format(" waiting [%s] %s", state.getWaiting().getReason(), message != null ? message : "No message"));
        }
        return sb.toString();
    }

    public void onDelete(Pod pod, boolean deletedFinalStateUnknown) {
    }

    public void onAdd(Pod pod) {
    }
}

