/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.Objects;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class PersistentVolumeClaimWorkspaceVolume
extends WorkspaceVolume {
    private String claimName;
    @CheckForNull
    private Boolean readOnly;

    @DataBoundConstructor
    public PersistentVolumeClaimWorkspaceVolume(String claimName, Boolean readOnly) {
        this.claimName = claimName;
        this.readOnly = readOnly;
    }

    public String getClaimName() {
        return this.claimName;
    }

    @NonNull
    public Boolean getReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewPersistentVolumeClaim().withClaimName(this.getClaimName())).withReadOnly(this.getReadOnly())).and()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimWorkspaceVolume that = (PersistentVolumeClaimWorkspaceVolume)o;
        return Objects.equals(this.claimName, that.claimName) && Objects.equals(this.readOnly, that.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.claimName, this.readOnly);
    }

    @Extension
    @Symbol(value={"persistentVolumeClaimWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "Persistent Volume Claim Workspace Volume";
        }
    }
}

