/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class PersistentVolumeClaim
extends PodVolume {
    private String mountPath;
    private String claimName;
    @CheckForNull
    private Boolean readOnly;

    @DataBoundConstructor
    public PersistentVolumeClaim(String mountPath, String claimName, Boolean readOnly) {
        this.mountPath = mountPath;
        this.claimName = claimName;
        this.readOnly = readOnly;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    public String getClaimName() {
        return this.claimName;
    }

    @NonNull
    public Boolean getReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewPersistentVolumeClaim().withClaimName(this.getClaimName())).withReadOnly(this.getReadOnly())).and()).build();
    }

    @Extension
    @Symbol(value={"persistentVolumeClaim"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Persistent Volume Claim";
        }
    }
}

