/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pod.decorator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.pod.decorator.PodDecorator;

@Extension
public class DefaultWorkspaceVolume
implements PodDecorator {
    private static final String WORKSPACE_VOLUME_NAME = "workspace-volume";
    public static final Predicate<Volume> WORKSPACE_VOLUME_PREDICATE = v -> WORKSPACE_VOLUME_NAME.equals(v.getName());
    private static final Volume DEFAULT_WORKSPACE_VOLUME = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("workspace-volume")).withNewEmptyDir().endEmptyDir()).build();
    private static final VolumeMount DEFAULT_WORKSPACE_VOLUME_MOUNT = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("workspace-volume")).withReadOnly(Boolean.valueOf(false))).build();

    @Override
    @NonNull
    public Pod decorate(@NonNull KubernetesCloud kubernetesCloud, @NonNull Pod pod) {
        PodSpec podSpec = pod.getSpec();
        if (podSpec.getVolumes().stream().noneMatch(WORKSPACE_VOLUME_PREDICATE)) {
            pod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editSpec().addNewVolumeLike(DEFAULT_WORKSPACE_VOLUME).endVolume()).endSpec()).build();
        }
        pod.getSpec().getContainers().stream().filter(c -> c.getVolumeMounts().stream().noneMatch(vm -> vm.getMountPath().equals(this.getWorkingDir((Container)c)))).forEach(c -> {
            List<VolumeMount> volumeMounts = c.getVolumeMounts() == null ? new ArrayList() : c.getVolumeMounts();
            volumeMounts.add(((VolumeMountBuilder)new VolumeMountBuilder(DEFAULT_WORKSPACE_VOLUME_MOUNT).withMountPath(this.getWorkingDir((Container)c))).build());
            c.setVolumeMounts(volumeMounts);
        });
        return pod;
    }

    private String getWorkingDir(Container c) {
        return c.getWorkingDir() != null ? c.getWorkingDir() : "/home/jenkins/agent";
    }
}

