/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStep;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Reaper;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.flow.ErrorCondition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.AgentErrorCondition;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class KubernetesAgentErrorCondition
extends ErrorCondition {
    private static final Logger LOGGER = Logger.getLogger(KubernetesAgentErrorCondition.class.getName());
    private static final Set<String> IGNORED_CONTAINER_TERMINATION_REASONS = Set.of("OOMKilled", "Completed", "DeadlineExceeded");
    private boolean handleNonKubernetes;

    @DataBoundConstructor
    public KubernetesAgentErrorCondition() {
    }

    public boolean isHandleNonKubernetes() {
        return this.handleNonKubernetes;
    }

    @DataBoundSetter
    public void setHandleNonKubernetes(boolean handleNonKubernetes) {
        this.handleNonKubernetes = handleNonKubernetes;
    }

    public boolean test(@NonNull Throwable t, @CheckForNull StepContext context) throws IOException, InterruptedException {
        if (context == null) {
            LOGGER.fine("Cannot check error without context");
            return this.handleNonKubernetes;
        }
        if (!new AgentErrorCondition().test(t, context)) {
            LOGGER.fine(() -> "Not a recognized failure: " + String.valueOf(t));
            return false;
        }
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FlowNode _origin = ErrorAction.findOrigin((Throwable)t, (FlowExecution)((FlowExecution)context.get(FlowExecution.class)));
        if (_origin == null) {
            if (!this.handleNonKubernetes) {
                listener.getLogger().println("Unable to identify source of error (" + String.valueOf(t) + ") to see if this was associated with a Kubernetes agent");
            }
            return this.handleNonKubernetes;
        }
        FlowNode origin = _origin instanceof BlockEndNode ? ((BlockEndNode)_origin).getStartNode() : _origin;
        LOGGER.fine(() -> "Found origin " + String.valueOf(origin) + " " + origin.getDisplayFunctionName());
        LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
        scanner.setup(origin);
        boolean foundPodTemplate = false;
        for (FlowNode callStack : scanner) {
            WorkspaceAction ws = (WorkspaceAction)callStack.getPersistentAction(WorkspaceAction.class);
            if (ws != null) {
                Set<String> terminationReasons;
                String node = ws.getNode();
                Node n = Jenkins.get().getNode(node);
                if (n != null) {
                    if (!(n instanceof KubernetesSlave)) {
                        if (!this.handleNonKubernetes) {
                            listener.getLogger().println(node + " was not a Kubernetes agent");
                        }
                        return this.handleNonKubernetes;
                    }
                } else {
                    Set labels = ws.getLabels();
                    if (labels.stream().noneMatch(l -> Jenkins.get().clouds.stream().anyMatch(c -> c instanceof KubernetesCloud && ((KubernetesCloud)c).getTemplate((Label)l) != null))) {
                        if (!this.handleNonKubernetes) {
                            listener.getLogger().println(node + " did not look like a Kubernetes agent judging by " + String.valueOf(labels) + "; make sure retry is inside podTemplate, not outside");
                        }
                        return this.handleNonKubernetes;
                    }
                }
                if (!(terminationReasons = ((Reaper)((Object)ExtensionList.lookupSingleton(Reaper.class))).terminationReasons(node)).isEmpty()) {
                    if (terminationReasons.stream().allMatch(IGNORED_CONTAINER_TERMINATION_REASONS::contains)) {
                        listener.getLogger().println("Ignored termination reason(s) for " + node + " for purposes of retry: " + String.valueOf(terminationReasons));
                        return false;
                    }
                }
                LOGGER.fine(() -> "active on " + node + " (termination reasons: " + String.valueOf(terminationReasons) + ")");
                return true;
            }
            foundPodTemplate |= callStack instanceof StepNode && ((StepNode)callStack).getDescriptor() instanceof PodTemplateStep.DescriptorImpl;
        }
        if (!this.handleNonKubernetes) {
            if (foundPodTemplate) {
                listener.getLogger().println("Could not find a node block associated with " + origin.getDisplayFunctionName() + " (source of error) but inside podTemplate");
                return true;
            }
            listener.getLogger().println("Could not find a node block associated with " + origin.getDisplayFunctionName() + " (source of error)");
        }
        return this.handleNonKubernetes;
    }

    @Symbol(value={"kubernetesAgent"})
    @Extension
    public static final class DescriptorImpl
    extends ErrorCondition.ErrorConditionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Kubernetes agent errors";
        }
    }
}

