/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.security.Permission;
import hudson.slaves.NodeProperty;
import hudson.util.FormApply;
import hudson.util.XStream2;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateBuilder;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateGroup;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateToolLocation;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.csanchez.jenkins.plugins.kubernetes.pod.yaml.YamlMergeStrategy;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class PodTemplate
extends AbstractDescribableImpl<PodTemplate>
implements Serializable,
Saveable {
    private static final long serialVersionUID = 3285310269140845583L;
    private static final String FALLBACK_ARGUMENTS = "${computer.jnlpmac} ${computer.name}";
    private static final String DEFAULT_LABEL = "slave-default";
    private static final Logger LOGGER = Logger.getLogger(PodTemplate.class.getName());
    public static final Integer DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT = Integer.getInteger(PodTemplate.class.getName() + ".connectionTimeout", 1000);
    public static final String JENKINS_LABEL = "jenkins/label";
    public static final String JENKINS_LABEL_DIGEST = "jenkins/label-digest";
    @CheckForNull
    private transient Run<?, ?> run;
    private String id;
    private transient boolean unwrapped;
    private String inheritFrom;
    private String name;
    private String namespace;
    private String image;
    private boolean privileged;
    private Long runAsUser;
    private Long runAsGroup;
    private String supplementalGroups;
    private boolean capOnlyOnAlivePods;
    private boolean alwaysPullImage;
    private String command;
    private String args;
    private String remoteFs;
    private int instanceCap = Integer.MAX_VALUE;
    private int slaveConnectTimeout = DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT;
    private int idleMinutes;
    private int activeDeadlineSeconds;
    private String label;
    private transient Set<LabelAtom> labelSet;
    private transient Map<String, String> labelsMap;
    private String serviceAccount;
    private String schedulerName;
    private String nodeSelector;
    private Node.Mode nodeUsageMode;
    private String resourceRequestCpu;
    private String resourceRequestMemory;
    private String resourceRequestEphemeralStorage;
    private String resourceLimitCpu;
    private String resourceLimitMemory;
    private String resourceLimitEphemeralStorage;
    private Boolean hostNetwork;
    private WorkspaceVolume workspaceVolume;
    private final List<PodVolume> volumes = new ArrayList<PodVolume>();
    private List<ContainerTemplate> containers = new ArrayList<ContainerTemplate>();
    private List<TemplateEnvVar> envVars = new ArrayList<TemplateEnvVar>();
    private List<PodAnnotation> annotations = new ArrayList<PodAnnotation>();
    private List<PodImagePullSecret> imagePullSecrets = new ArrayList<PodImagePullSecret>();
    private PodTemplateToolLocation nodeProperties;
    private Long terminationGracePeriodSeconds;
    private String agentContainer;
    private boolean agentInjection;
    private String yaml;
    private transient List<String> yamls;
    private transient boolean readonlyFromUi;
    private YamlMergeStrategy yamlMergeStrategy;
    @CheckForNull
    private Boolean inheritYamlMergeStrategy;
    private Boolean showRawYaml;
    @CheckForNull
    private transient TaskListener listener;
    @CheckForNull
    private PodRetention podRetention;

    protected static MessageDigest getLabelDigestFunction() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e);
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @CheckForNull
    public YamlMergeStrategy getYamlMergeStrategy() {
        return this.yamlMergeStrategy;
    }

    @NonNull
    public YamlMergeStrategy getResolvedYamlMergeStrategy() {
        return Optional.ofNullable(this.getYamlMergeStrategy()).orElse(YamlMergeStrategy.defaultStrategy());
    }

    @DataBoundSetter
    public void setYamlMergeStrategy(@CheckForNull YamlMergeStrategy yamlMergeStrategy) {
        this.yamlMergeStrategy = yamlMergeStrategy;
    }

    public Pod getYamlsPod() {
        return this.getResolvedYamlMergeStrategy().merge(this.getYamls());
    }

    public PodTemplate() {
        this((String)null);
    }

    @DataBoundConstructor
    public PodTemplate(@CheckForNull String id) {
        this.id = Util.fixEmpty((String)id) == null ? UUID.randomUUID().toString() : id;
        this.recomputeLabelDerivedFields();
    }

    public PodTemplate(PodTemplate from) {
        XStream2 xs = new XStream2();
        xs.unmarshal(XStream2.getDefaultDriver().createReader((Reader)new StringReader(xs.toXML((Object)from))), (Object)this);
        this.yamls = from.yamls;
        this.listener = from.listener;
        this.recomputeLabelDerivedFields();
    }

    @Deprecated
    public PodTemplate(String image, List<? extends PodVolume> volumes) {
        this(null, image, volumes);
    }

    @Deprecated
    PodTemplate(String name, String image, List<? extends PodVolume> volumes) {
        this(name, volumes, Collections.emptyList());
        if (image != null) {
            this.getContainers().add(new ContainerTemplate(name, image));
        }
    }

    @Restricted(value={NoExternalUse.class})
    PodTemplate(String name, List<? extends PodVolume> volumes, List<? extends ContainerTemplate> containers) {
        this();
        this.name = name;
        this.volumes.addAll(volumes);
        this.containers.addAll(containers);
    }

    private Optional<ContainerTemplate> getFirstContainer() {
        return Optional.ofNullable(this.getContainers().isEmpty() ? null : this.getContainers().get(0));
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = Util.fixEmptyAndTrim((String)inheritFrom);
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = Util.fixEmptyAndTrim((String)name);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = Util.fixEmptyAndTrim((String)namespace);
    }

    @Deprecated
    public String getImage() {
        return this.getFirstContainer().map(ContainerTemplate::getImage).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setCommand(String command) {
        this.getFirstContainer().ifPresent(i -> i.setCommand(command));
    }

    @Deprecated
    public String getCommand() {
        return this.getFirstContainer().map(ContainerTemplate::getCommand).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setArgs(String args) {
        this.getFirstContainer().ifPresent(i -> i.setArgs(args));
    }

    @Deprecated
    public String getArgs() {
        return this.getFirstContainer().map(ContainerTemplate::getArgs).orElse(null);
    }

    @Deprecated
    public String getDisplayName() {
        return "Kubernetes Pod Template";
    }

    @DataBoundSetter
    @Deprecated
    public void setRemoteFs(String remoteFs) {
        this.getFirstContainer().ifPresent(i -> i.setWorkingDir(remoteFs));
    }

    @Deprecated
    public String getRemoteFs() {
        return this.getFirstContainer().map(ContainerTemplate::getWorkingDir).orElse("/home/jenkins/agent");
    }

    @DataBoundSetter
    public void setInstanceCap(int instanceCap) {
        this.instanceCap = instanceCap < 0 ? Integer.MAX_VALUE : instanceCap;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    @DataBoundSetter
    public void setSlaveConnectTimeout(int slaveConnectTimeout) {
        if (slaveConnectTimeout <= 0) {
            LOGGER.log(Level.WARNING, "Agent -> Jenkins connection timeout cannot be <= 0. Falling back to the default value: " + DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT);
            this.slaveConnectTimeout = DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT;
        } else {
            this.slaveConnectTimeout = slaveConnectTimeout;
        }
    }

    public int getSlaveConnectTimeout() {
        if (this.slaveConnectTimeout == 0) {
            return DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT;
        }
        return this.slaveConnectTimeout;
    }

    @DataBoundSetter
    public void setInstanceCapStr(String instanceCapStr) {
        if (StringUtils.isBlank((String)instanceCapStr)) {
            this.setInstanceCap(Integer.MAX_VALUE);
        } else {
            this.setInstanceCap(Integer.parseInt(instanceCapStr));
        }
    }

    public String getInstanceCapStr() {
        if (this.getInstanceCap() == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    @DataBoundSetter
    public void setSlaveConnectTimeoutStr(String slaveConnectTimeoutStr) {
        if (StringUtils.isBlank((String)slaveConnectTimeoutStr)) {
            this.setSlaveConnectTimeout(DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT);
        } else {
            this.setSlaveConnectTimeout(Integer.parseInt(slaveConnectTimeoutStr));
        }
    }

    public String getSlaveConnectTimeoutStr() {
        return String.valueOf(this.slaveConnectTimeout);
    }

    @DataBoundSetter
    public void setIdleMinutes(int i) {
        this.idleMinutes = i;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    @DataBoundSetter
    public void setActiveDeadlineSeconds(int i) {
        this.activeDeadlineSeconds = i;
    }

    public int getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @DataBoundSetter
    public void setIdleMinutesStr(String idleMinutes) {
        if (StringUtils.isBlank((String)idleMinutes)) {
            this.setIdleMinutes(0);
        } else {
            this.setIdleMinutes(Integer.parseInt(idleMinutes));
        }
    }

    public String getIdleMinutesStr() {
        if (this.getIdleMinutes() == 0) {
            return "";
        }
        return String.valueOf(this.idleMinutes);
    }

    @DataBoundSetter
    public void setActiveDeadlineSecondsStr(String activeDeadlineSeconds) {
        if (StringUtils.isBlank((String)activeDeadlineSeconds)) {
            this.setActiveDeadlineSeconds(0);
        } else {
            this.setActiveDeadlineSeconds(Integer.parseInt(activeDeadlineSeconds));
        }
    }

    public String getActiveDeadlineSecondsStr() {
        if (this.getActiveDeadlineSeconds() == 0) {
            return "";
        }
        return String.valueOf(this.activeDeadlineSeconds);
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public Map<String, String> getLabelsMap() {
        return this.labelsMap;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = Util.fixEmptyAndTrim((String)label);
        this.recomputeLabelDerivedFields();
    }

    private void recomputeLabelDerivedFields() {
        this.labelSet = Label.parse((String)this.label);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if (this.label == null) {
            tempMap.put(JENKINS_LABEL, DEFAULT_LABEL);
            tempMap.put(JENKINS_LABEL_DIGEST, "0");
        } else {
            MessageDigest labelDigestFunction = PodTemplate.getLabelDigestFunction();
            labelDigestFunction.update(this.label.getBytes(StandardCharsets.UTF_8));
            tempMap.put(JENKINS_LABEL, PodTemplateUtils.sanitizeLabel(this.label));
            tempMap.put(JENKINS_LABEL_DIGEST, String.format("%040x", new BigInteger(1, labelDigestFunction.digest())));
        }
        this.labelsMap = Collections.unmodifiableMap(tempMap);
    }

    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = Util.fixEmptyAndTrim((String)nodeSelector);
    }

    public String getNodeSelector() {
        return this.nodeSelector;
    }

    @DataBoundSetter
    public void setNodeUsageMode(Node.Mode nodeUsageMode) {
        this.nodeUsageMode = nodeUsageMode == Node.Mode.EXCLUSIVE ? null : nodeUsageMode;
    }

    @DataBoundSetter
    public void setNodeUsageMode(String nodeUsageMode) {
        this.setNodeUsageMode(Node.Mode.valueOf((String)nodeUsageMode));
    }

    public Node.Mode getNodeUsageMode() {
        return this.nodeUsageMode == null ? Node.Mode.EXCLUSIVE : this.nodeUsageMode;
    }

    @Deprecated
    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.getFirstContainer().ifPresent(i -> i.setPrivileged(privileged));
    }

    @Deprecated
    public boolean isPrivileged() {
        return this.getFirstContainer().map(ContainerTemplate::isPrivileged).orElse(false);
    }

    @DataBoundSetter
    public void setRunAsUser(String runAsUser) {
        this.runAsUser = PodTemplateUtils.parseLong(runAsUser);
    }

    public String getRunAsUser() {
        return this.runAsUser == null ? null : this.runAsUser.toString();
    }

    public Long getRunAsUserAsLong() {
        return this.runAsUser;
    }

    @DataBoundSetter
    public void setRunAsGroup(String runAsGroup) {
        this.runAsGroup = PodTemplateUtils.parseLong(runAsGroup);
    }

    public String getRunAsGroup() {
        return this.runAsGroup == null ? null : this.runAsGroup.toString();
    }

    public Long getRunAsGroupAsLong() {
        return this.runAsGroup;
    }

    @DataBoundSetter
    public void setSupplementalGroups(String supplementalGroups) {
        this.supplementalGroups = Util.fixEmpty((String)supplementalGroups);
    }

    public String getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @DataBoundSetter
    public void setHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public boolean isHostNetwork() {
        return this.isHostNetworkSet() ? this.hostNetwork : false;
    }

    public boolean isHostNetworkSet() {
        return this.hostNetwork != null;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @DataBoundSetter
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = Util.fixEmpty((String)serviceAccount);
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    @DataBoundSetter
    public void setSchedulerName(String schedulerName) {
        this.schedulerName = Util.fixEmpty((String)schedulerName);
    }

    @Deprecated
    @DataBoundSetter
    public void setAlwaysPullImage(boolean alwaysPullImage) {
        this.getFirstContainer().ifPresent(i -> i.setAlwaysPullImage(alwaysPullImage));
    }

    @Deprecated
    public boolean isAlwaysPullImage() {
        return this.getFirstContainer().map(ContainerTemplate::isAlwaysPullImage).orElse(false);
    }

    @DataBoundSetter
    @Deprecated
    public void setCapOnlyOnAlivePods(boolean capOnlyOnAlivePods) {
        this.capOnlyOnAlivePods = capOnlyOnAlivePods;
    }

    @Deprecated
    public boolean isCapOnlyOnAlivePods() {
        return this.capOnlyOnAlivePods;
    }

    @CheckForNull
    public String getAgentContainer() {
        return this.agentContainer;
    }

    @DataBoundSetter
    public void setAgentContainer(@CheckForNull String agentContainer) {
        this.agentContainer = Util.fixEmpty((String)agentContainer);
    }

    public boolean isAgentInjection() {
        return this.agentInjection;
    }

    @DataBoundSetter
    public void setAgentInjection(boolean agentInjection) {
        this.agentInjection = agentInjection;
    }

    public List<TemplateEnvVar> getEnvVars() {
        if (this.envVars == null) {
            return Collections.emptyList();
        }
        return this.envVars;
    }

    public void addEnvVars(List<TemplateEnvVar> envVars) {
        if (envVars != null) {
            this.envVars.addAll(envVars);
        }
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasManagePermission() {
        PodTemplateGroup groupFromRequest;
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request != null && (groupFromRequest = (PodTemplateGroup)request.findAncestorObject(PodTemplateGroup.class)) != null) {
            return groupFromRequest.hasManagePermission();
        }
        return Jenkins.get().hasPermission(Jenkins.MANAGE);
    }

    @POST
    public HttpResponse doDoDelete(@AncestorInPath PodTemplateGroup owner) throws IOException {
        if (owner == null) {
            throw new IllegalStateException("Cloud could not be found");
        }
        Jenkins j = Jenkins.get();
        owner.checkManagePermission();
        owner.removeTemplate(this);
        j.save();
        return new HttpRedirect(owner.getPodTemplateGroupUrl());
    }

    @POST
    public HttpResponse doConfigSubmit(StaplerRequest2 req, @AncestorInPath PodTemplateGroup owner) throws IOException, ServletException, Descriptor.FormException {
        if (owner == null) {
            throw new IllegalStateException("Cloud could not be found");
        }
        Jenkins j = Jenkins.get();
        owner.checkManagePermission();
        PodTemplate newTemplate = this.reconfigure(req, req.getSubmittedForm());
        owner.replaceTemplate(this, newTemplate);
        j.save();
        return FormApply.success((String)owner.getPodTemplateGroupUrl());
    }

    private PodTemplate reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        return (PodTemplate)this.getDescriptor().newInstance(req, form);
    }

    @DataBoundSetter
    public void setEnvVars(List<TemplateEnvVar> envVars) {
        if (envVars != null) {
            this.envVars.clear();
            this.addEnvVars(envVars);
        }
    }

    public List<PodAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    public void addAnnotations(List<PodAnnotation> annotations) {
        this.annotations.addAll(annotations);
    }

    @DataBoundSetter
    public void setAnnotations(List<PodAnnotation> annotations) {
        if (annotations != null) {
            this.annotations = new ArrayList<PodAnnotation>();
            this.addAnnotations(annotations);
        }
    }

    public List<PodImagePullSecret> getImagePullSecrets() {
        return this.imagePullSecrets == null ? Collections.emptyList() : this.imagePullSecrets;
    }

    public void addImagePullSecrets(List<PodImagePullSecret> imagePullSecrets) {
        this.imagePullSecrets.addAll(imagePullSecrets);
    }

    @DataBoundSetter
    public void setImagePullSecrets(List<PodImagePullSecret> imagePullSecrets) {
        if (imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this.addImagePullSecrets(imagePullSecrets);
        }
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> properties) {
        this.getNodeProperties().clear();
        this.getNodeProperties().addAll(properties);
    }

    @NonNull
    public PodTemplateToolLocation getNodeProperties() {
        if (this.nodeProperties == null) {
            this.nodeProperties = new PodTemplateToolLocation(this);
        }
        return this.nodeProperties;
    }

    @Deprecated
    public String getResourceRequestMemory() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceRequestMemory).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceRequestMemory(String resourceRequestMemory) {
        this.getFirstContainer().ifPresent(i -> i.setResourceRequestMemory(resourceRequestMemory));
    }

    @Deprecated
    public String getResourceLimitCpu() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceLimitCpu).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceLimitCpu(String resourceLimitCpu) {
        this.getFirstContainer().ifPresent(i -> i.setResourceLimitCpu(resourceLimitCpu));
    }

    @Deprecated
    public String getResourceLimitMemory() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceLimitMemory).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceLimitMemory(String resourceLimitMemory) {
        this.getFirstContainer().ifPresent(i -> i.setResourceLimitMemory(resourceLimitMemory));
    }

    @Deprecated
    public String getResourceRequestCpu() {
        return this.getFirstContainer().map(ContainerTemplate::getResourceRequestCpu).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setResourceRequestCpu(String resourceRequestCpu) {
        this.getFirstContainer().ifPresent(i -> i.setResourceRequestCpu(resourceRequestCpu));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setVolumes(@NonNull List<PodVolume> items) {
        List<PodVolume> list = this.volumes;
        synchronized (list) {
            this.volumes.clear();
            this.volumes.addAll(items);
        }
    }

    @NonNull
    public List<PodVolume> getVolumes() {
        if (this.volumes == null) {
            return Collections.emptyList();
        }
        return this.volumes;
    }

    @NonNull
    public WorkspaceVolume getWorkspaceVolume() {
        return this.workspaceVolume == null ? WorkspaceVolume.getDefault() : this.workspaceVolume;
    }

    @DataBoundSetter
    public void setWorkspaceVolume(WorkspaceVolume workspaceVolume) {
        this.workspaceVolume = WorkspaceVolume.getDefault().equals(workspaceVolume) ? null : workspaceVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setContainers(@NonNull List<ContainerTemplate> items) {
        List<ContainerTemplate> list = this.containers;
        synchronized (list) {
            this.containers.clear();
            this.containers.addAll(items);
        }
    }

    @NonNull
    public final List<ContainerTemplate> getContainers() {
        if (this.containers == null) {
            return Collections.emptyList();
        }
        return this.containers;
    }

    public String getYaml() {
        return this.yaml;
    }

    @DataBoundSetter
    public void setYaml(String yaml) {
        this.yaml = Util.fixEmpty((String)yaml);
    }

    @NonNull
    public List<String> getYamls() {
        if (this.yamls == null || this.yamls.isEmpty()) {
            if (this.yaml != null) {
                return Collections.singletonList(this.yaml);
            }
            return Collections.emptyList();
        }
        return this.yamls;
    }

    @Restricted(value={NoExternalUse.class})
    List<String> _getYamls() {
        return this.yamls;
    }

    public void setYamls(List<String> yamls) {
        if (yamls != null) {
            ArrayList<String> ys = new ArrayList<String>();
            for (String y : yamls) {
                String trimmed = Util.fixEmpty((String)y);
                if (trimmed == null) continue;
                ys.add(trimmed);
            }
            this.yamls = ys;
        } else {
            this.yamls = Collections.emptyList();
        }
    }

    public PodRetention getPodRetention() {
        return this.podRetention == null ? PodRetention.getPodTemplateDefault() : this.podRetention;
    }

    @DataBoundSetter
    public void setPodRetention(PodRetention podRetention) {
        this.podRetention = ((Object)((Object)PodRetention.getPodTemplateDefault())).equals((Object)podRetention) ? null : podRetention;
    }

    @NonNull
    public TaskListener getListener() {
        return this.listener == null ? TaskListener.NULL : this.listener;
    }

    @CheckForNull
    public TaskListener getListenerOrNull() {
        return this.listener;
    }

    public void setListener(@CheckForNull TaskListener listener) {
        this.listener = listener;
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public void setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    protected Object readResolve() {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerTemplate>();
            ContainerTemplate containerTemplate = new ContainerTemplate("jnlp", this.image);
            containerTemplate.setCommand(this.command);
            containerTemplate.setArgs(PodTemplateUtils.isNullOrEmpty(this.args) ? FALLBACK_ARGUMENTS : this.args);
            containerTemplate.setPrivileged(this.privileged);
            containerTemplate.setRunAsUser(this.getRunAsUser());
            containerTemplate.setRunAsGroup(this.getRunAsGroup());
            containerTemplate.setAlwaysPullImage(this.alwaysPullImage);
            containerTemplate.setEnvVars(this.envVars);
            containerTemplate.setResourceLimitMemory(this.resourceLimitMemory);
            containerTemplate.setResourceLimitCpu(this.resourceLimitCpu);
            containerTemplate.setResourceLimitEphemeralStorage(this.resourceLimitEphemeralStorage);
            containerTemplate.setResourceRequestMemory(this.resourceRequestMemory);
            containerTemplate.setResourceRequestCpu(this.resourceRequestCpu);
            containerTemplate.setResourceRequestEphemeralStorage(this.resourceRequestEphemeralStorage);
            containerTemplate.setWorkingDir(this.remoteFs);
            this.containers.add(containerTemplate);
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<PodAnnotation>();
        }
        this.yaml = Util.fixEmpty((String)this.yaml);
        if (this.yamls != null) {
            this.setYamls(this.yamls);
            if (!this.yamls.isEmpty()) {
                if (this.yamls.size() > 1) {
                    LOGGER.log(Level.WARNING, "Found several persisted YAML fragments in pod template " + this.name + ". Only the first fragment will be considered, others will be ignored.");
                }
                this.yaml = this.yamls.get(0);
            }
            this.yamls = null;
        }
        if (this.id == null) {
            this.id = this.getLabel() + "-" + Util.getDigestOf((String)this.toString());
        }
        this.recomputeLabelDerivedFields();
        return this;
    }

    @Deprecated
    public Pod build(KubernetesClient client, KubernetesSlave slave) {
        return this.build(slave);
    }

    public Pod build(KubernetesSlave slave) {
        return new PodTemplateBuilder(this, slave).build();
    }

    @Deprecated
    public String getDescriptionForLogging() {
        return String.format("Agent specification [%s] (%s): %n%s", this.getName(), this.getLabel(), this.getContainersDescriptionForLogging());
    }

    public boolean isInheritYamlMergeStrategy() {
        return Optional.ofNullable(this.inheritYamlMergeStrategy).orElse(false);
    }

    @DataBoundSetter
    public void setInheritYamlMergeStrategy(boolean inheritYamlMergeStrategy) {
        this.inheritYamlMergeStrategy = inheritYamlMergeStrategy;
    }

    boolean isShowRawYamlSet() {
        return this.showRawYaml != null;
    }

    public boolean isShowRawYaml() {
        return this.isShowRawYamlSet() ? this.showRawYaml : true;
    }

    @DataBoundSetter
    public void setShowRawYaml(boolean showRawYaml) {
        this.showRawYaml = showRawYaml;
    }

    void setUnwrapped(boolean unwrapped) {
        this.unwrapped = unwrapped;
    }

    boolean isUnwrapped() {
        return this.unwrapped;
    }

    private String getContainersDescriptionForLogging() {
        List<ContainerTemplate> containers = this.getContainers();
        StringBuilder sb = new StringBuilder();
        for (ContainerTemplate ct : containers) {
            sb.append("* [").append(ct.getName()).append("] ").append(ct.getImage());
            StringBuilder optional = new StringBuilder();
            this.optionalField(optional, "resourceRequestCpu", ct.getResourceRequestCpu());
            this.optionalField(optional, "resourceRequestMemory", ct.getResourceRequestMemory());
            this.optionalField(optional, "resourceRequestEphemeralStorage", ct.getResourceRequestEphemeralStorage());
            this.optionalField(optional, "resourceLimitCpu", ct.getResourceLimitCpu());
            this.optionalField(optional, "resourceLimitMemory", ct.getResourceLimitMemory());
            this.optionalField(optional, "resourceLimitEphemeralStorage", ct.getResourceLimitEphemeralStorage());
            if (optional.length() > 0) {
                sb.append("(").append((CharSequence)optional).append(")");
            }
            sb.append("\n");
        }
        if (this.isShowRawYaml()) {
            for (String yaml : this.getYamls()) {
                sb.append("yaml:\n").append(yaml).append("\n");
            }
        }
        return sb.toString();
    }

    private void optionalField(StringBuilder builder, String label, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(label).append(": ").append(value);
        }
    }

    public void save() {
    }

    public boolean isReadonlyFromUi() {
        return this.readonlyFromUi;
    }

    public void setReadonlyFromUi(boolean readonlyFromUi) {
        this.readonlyFromUi = readonlyFromUi;
    }

    public void setRun(Run<?, ?> run) {
        this.run = run;
    }

    @CheckForNull
    public Run<?, ?> getRun() {
        return this.run;
    }

    public String toString() {
        return "PodTemplate{" + (String)(this.id == null ? "" : "id='" + this.id + "'") + (String)(this.inheritFrom == null ? "" : ", inheritFrom='" + this.inheritFrom + "'") + (String)(this.name == null ? "" : ", name='" + this.name + "'") + (String)(this.namespace == null ? "" : ", namespace='" + this.namespace + "'") + (String)(this.image == null ? "" : ", image='" + this.image + "'") + (String)(!this.privileged ? "" : ", privileged=" + this.privileged) + (String)(this.runAsUser == null ? "" : ", runAsUser=" + this.runAsUser) + (String)(this.runAsGroup == null ? "" : ", runAsGroup=" + this.runAsGroup) + (String)(!this.isHostNetwork() ? "" : ", hostNetwork=" + this.hostNetwork) + (String)(!this.alwaysPullImage ? "" : ", alwaysPullImage=" + this.alwaysPullImage) + (String)(this.command == null ? "" : ", command='" + this.command + "'") + (String)(this.args == null ? "" : ", args='" + this.args + "'") + (String)(this.remoteFs == null ? "" : ", remoteFs='" + this.remoteFs + "'") + (String)(this.instanceCap == Integer.MAX_VALUE ? "" : ", instanceCap=" + this.instanceCap) + (String)(this.slaveConnectTimeout == DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT ? "" : ", slaveConnectTimeout=" + this.slaveConnectTimeout) + (String)(this.idleMinutes == 0 ? "" : ", idleMinutes=" + this.idleMinutes) + (String)(this.activeDeadlineSeconds == 0 ? "" : ", activeDeadlineSeconds=" + this.activeDeadlineSeconds) + (String)(this.label == null ? "" : ", label='" + this.label + "'") + (String)(this.serviceAccount == null ? "" : ", serviceAccount='" + this.serviceAccount + "'") + (String)(this.schedulerName == null ? "" : ", schedulerName='" + this.schedulerName + "'") + (String)(this.nodeSelector == null ? "" : ", nodeSelector='" + this.nodeSelector + "'") + (String)(this.nodeUsageMode == null ? "" : ", nodeUsageMode=" + String.valueOf(this.nodeUsageMode)) + (String)(this.resourceRequestCpu == null ? "" : ", resourceRequestCpu='" + this.resourceRequestCpu + "'") + (String)(this.resourceRequestMemory == null ? "" : ", resourceRequestMemory='" + this.resourceRequestMemory + "'") + (String)(this.resourceRequestEphemeralStorage == null ? "" : ", resourceRequestEphemeralStorage='" + this.resourceRequestEphemeralStorage + "'") + (String)(this.resourceLimitCpu == null ? "" : ", resourceLimitCpu='" + this.resourceLimitCpu + "'") + (String)(this.resourceLimitMemory == null ? "" : ", resourceLimitMemory='" + this.resourceLimitMemory + "'") + (String)(this.resourceLimitEphemeralStorage == null ? "" : ", resourceLimitEphemeralStorage='" + this.resourceLimitEphemeralStorage + "'") + (String)(this.workspaceVolume == null ? "" : ", workspaceVolume='" + String.valueOf(this.workspaceVolume) + "'") + (String)(this.podRetention == null ? "" : ", podRetention='" + String.valueOf((Object)this.podRetention) + "'") + (String)(this.volumes == null || this.volumes.isEmpty() ? "" : ", volumes=" + String.valueOf(this.volumes)) + (String)(this.containers == null || this.containers.isEmpty() ? "" : ", containers=" + String.valueOf(this.containers)) + (String)(this.envVars == null || this.envVars.isEmpty() ? "" : ", envVars=" + String.valueOf(this.envVars)) + (String)(this.annotations == null || this.annotations.isEmpty() ? "" : ", annotations=" + String.valueOf(this.annotations)) + (String)(this.imagePullSecrets == null || this.imagePullSecrets.isEmpty() ? "" : ", imagePullSecrets=" + String.valueOf(this.imagePullSecrets)) + (String)(this.nodeProperties == null || this.nodeProperties.isEmpty() ? "" : ", nodeProperties=" + String.valueOf(this.nodeProperties)) + (String)(this.yamls == null || this.yamls.isEmpty() ? "" : ", yamls=" + String.valueOf(this.yamls)) + (String)(!this.unwrapped ? "" : ", unwrapped=" + this.unwrapped) + (String)(this.agentContainer == null ? "" : ", agentContainer='" + this.agentContainer + "'") + (String)(!this.agentInjection ? "" : ", agentInjection=" + this.agentInjection) + "}";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PodTemplate> {
        static final String[] STRING_FIELDS = new String[]{"activeDeadlineSeconds", "idleMinutes", "instanceCap", "slaveConnectTimeout"};

        @NonNull
        public Permission getRequiredGlobalConfigPagePermission() {
            return Jenkins.MANAGE;
        }

        public DescriptorImpl() {
            for (String field : STRING_FIELDS) {
                this.addHelpFileRedirect(field + "Str", PodTemplate.class, field);
            }
        }

        public String getDisplayName() {
            return "Kubernetes Pod Template";
        }

        @Restricted(value={DoNotUse.class})
        public List<? extends Descriptor> getEnvVarsDescriptors() {
            return DescriptorVisibilityFilter.apply(null, (Iterable)Jenkins.get().getDescriptorList(TemplateEnvVar.class));
        }

        @Restricted(value={DoNotUse.class})
        public WorkspaceVolume getDefaultWorkspaceVolume() {
            return WorkspaceVolume.getDefault();
        }

        @Restricted(value={DoNotUse.class})
        public Descriptor getDefaultPodRetention() {
            return Jenkins.get().getDescriptor(((Object)((Object)PodRetention.getPodTemplateDefault())).getClass());
        }

        @Restricted(value={DoNotUse.class})
        public YamlMergeStrategy getDefaultYamlMergeStrategy() {
            return YamlMergeStrategy.defaultStrategy();
        }
    }
}

