/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Main;
import hudson.TcpSlaveAgentListener;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Saveable;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.metrics.api.Metrics;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.security.FIPS140;
import jenkins.util.SystemProperties;
import jenkins.websocket.WebSockets;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.GarbageCollection;
import org.csanchez.jenkins.plugins.kubernetes.InProvisioning;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesClientProvider;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloudTrait;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloudTraitDescriptor;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.LimitRegistrationResults;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PlannedNodeBuilderFactory;
import org.csanchez.jenkins.plugins.kubernetes.PodLabel;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateFilter;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateGroup;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateSource;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateMap;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Default;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.csanchez.jenkins.plugins.kubernetes.watch.PodStatusEventHandler;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.credentials.FileSystemServiceAccountCredential;
import org.jenkinsci.plugins.kubernetes.credentials.OpenShiftBearerTokenCredentialImpl;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class KubernetesCloud
extends Cloud
implements PodTemplateGroup {
    public static final int DEFAULT_MAX_REQUESTS_PER_HOST = 32;
    public static final Integer DEFAULT_WAIT_FOR_POD_SEC = 600;
    private static final Logger LOGGER = Logger.getLogger(KubernetesCloud.class.getName());
    public static final String JNLP_NAME = "jnlp";
    @Deprecated
    public static final Map<String, String> DEFAULT_POD_LABELS = Collections.singletonMap("jenkins", "slave");
    public static final int DEFAULT_RETENTION_TIMEOUT_MINUTES = 5;
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 15;
    public static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 5;
    private String defaultsProviderTemplate;
    @NonNull
    private List<PodTemplate> templates = new ArrayList<PodTemplate>();
    private String serverUrl;
    private boolean useJenkinsProxy;
    @CheckForNull
    private String serverCertificate;
    private boolean skipTlsVerify;
    private boolean addMasterProxyEnvVars;
    private boolean capOnlyOnAlivePods;
    private String namespace;
    private String jnlpregistry;
    private boolean restrictedPssSecurityContext = false;
    private boolean webSocket;
    private boolean directConnection = false;
    private String jenkinsUrl;
    @CheckForNull
    private String jenkinsTunnel;
    @CheckForNull
    private String credentialsId;
    private Integer containerCap;
    private int retentionTimeout = 5;
    private int connectTimeout = 5;
    private int readTimeout = 15;
    @Deprecated
    private transient Map<String, String> labels;
    private List<PodLabel> podLabels = new ArrayList<PodLabel>();
    private boolean usageRestricted;
    private int maxRequestsPerHost;
    private Integer waitForPodSec = DEFAULT_WAIT_FOR_POD_SEC;
    @CheckForNull
    private PodRetention podRetention = PodRetention.getKubernetesCloudDefault();
    @CheckForNull
    private GarbageCollection garbageCollection;
    @NonNull
    private DescribableList<KubernetesCloudTrait, KubernetesCloudTraitDescriptor> traits = new DescribableList(Saveable.NOOP);
    private volatile transient Map<String, SharedIndexInformer<Pod>> informers = new ConcurrentHashMap<String, SharedIndexInformer<Pod>>();

    @DataBoundConstructor
    public KubernetesCloud(String name) {
        super(name);
        this.setMaxRequestsPerHost(32);
    }

    public KubernetesCloud(@NonNull String name, @NonNull KubernetesCloud source) {
        super(name);
        XStream2 xs = new XStream2();
        xs.omitField(Cloud.class, "name");
        xs.omitField(KubernetesCloud.class, "templates");
        xs.unmarshal(XStream2.getDefaultDriver().createReader((Reader)new StringReader(xs.toXML((Object)source))), (Object)this);
        this.templates.addAll(source.templates);
    }

    @Deprecated
    public KubernetesCloud(String name, List<? extends PodTemplate> templates, String serverUrl, String namespace, String jenkinsUrl, String containerCapStr, int connectTimeout, int readTimeout, int retentionTimeout) {
        this(name);
        this.setServerUrl(serverUrl);
        this.setNamespace(namespace);
        this.setJenkinsUrl(jenkinsUrl);
        if (templates != null) {
            this.templates.addAll(templates);
        }
        this.setContainerCapStr(containerCapStr);
        this.setRetentionTimeout(retentionTimeout);
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
    }

    public boolean isUseJenkinsProxy() {
        return this.useJenkinsProxy;
    }

    @DataBoundSetter
    public void setUseJenkinsProxy(boolean useJenkinsProxy) {
        this.useJenkinsProxy = useJenkinsProxy;
    }

    public boolean isUsageRestricted() {
        return this.usageRestricted;
    }

    @DataBoundSetter
    public void setUsageRestricted(boolean usageRestricted) {
        this.usageRestricted = usageRestricted;
    }

    public int getRetentionTimeout() {
        return this.retentionTimeout;
    }

    @DataBoundSetter
    public void setRetentionTimeout(int retentionTimeout) {
        this.retentionTimeout = Math.max(5, retentionTimeout);
    }

    public String getDefaultsProviderTemplate() {
        return this.defaultsProviderTemplate;
    }

    @DataBoundSetter
    public void setDefaultsProviderTemplate(String defaultsProviderTemplate) {
        this.defaultsProviderTemplate = Util.fixEmpty((String)defaultsProviderTemplate);
    }

    @NonNull
    public List<PodTemplate> getTemplates() {
        return this.templates;
    }

    @NonNull
    public List<PodTemplate> getAllTemplates() {
        return PodTemplateSource.getAll(this);
    }

    @DataBoundSetter
    public void setTemplates(@NonNull List<PodTemplate> templates) {
        this.templates = new ArrayList<PodTemplate>(templates);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@NonNull String serverUrl) {
        KubernetesCloud.ensureKubernetesUrlInFipsMode(serverUrl);
        this.serverUrl = Util.fixEmpty((String)serverUrl);
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    @DataBoundSetter
    public void setServerCertificate(String serverCertificate) {
        KubernetesCloud.ensureServerCertificateInFipsMode(serverCertificate);
        this.serverCertificate = Util.fixEmpty((String)serverCertificate);
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    @DataBoundSetter
    public void setSkipTlsVerify(boolean skipTlsVerify) {
        KubernetesCloud.ensureSkipTlsVerifyInFipsMode(skipTlsVerify);
        this.skipTlsVerify = skipTlsVerify;
    }

    public boolean isAddMasterProxyEnvVars() {
        return this.addMasterProxyEnvVars;
    }

    @DataBoundSetter
    public void setAddMasterProxyEnvVars(boolean addMasterProxyEnvVars) {
        this.addMasterProxyEnvVars = addMasterProxyEnvVars;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = Util.fixEmpty((String)namespace);
    }

    public String getJnlpregistry() {
        return this.jnlpregistry;
    }

    @DataBoundSetter
    public void setJnlpregistry(String jnlpregistry) {
        this.jnlpregistry = Util.fixEmpty((String)jnlpregistry);
    }

    public boolean isRestrictedPssSecurityContext() {
        return this.restrictedPssSecurityContext;
    }

    @DataBoundSetter
    public void setRestrictedPssSecurityContext(boolean restrictedPssSecurityContext) {
        this.restrictedPssSecurityContext = restrictedPssSecurityContext;
    }

    @CheckForNull
    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    @Deprecated
    public void setCapOnlyOnAlivePods(boolean capOnlyOnAlivePods) {
        this.capOnlyOnAlivePods = capOnlyOnAlivePods;
    }

    @Deprecated
    public boolean isCapOnlyOnAlivePods() {
        return this.capOnlyOnAlivePods;
    }

    public GarbageCollection getGarbageCollection() {
        return this.garbageCollection;
    }

    @DataBoundSetter
    public void setGarbageCollection(GarbageCollection garbageCollection) {
        this.garbageCollection = garbageCollection;
    }

    @NonNull
    public List<KubernetesCloudTrait> getTraits() {
        return this.traits;
    }

    @DataBoundSetter
    public void setTraits(List<KubernetesCloudTrait> traits) {
        this.traits = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(traits));
    }

    @NonNull
    public <T extends KubernetesCloudTrait> Optional<T> getTrait(Class<T> traitType) {
        return Optional.ofNullable((KubernetesCloudTrait)this.traits.get(traitType));
    }

    @NonNull
    public String getJenkinsUrlOrDie() {
        String url = this.getJenkinsUrlOrNull();
        if (url == null) {
            throw new IllegalStateException("Jenkins URL for Kubernetes is null");
        }
        return url;
    }

    @CheckForNull
    public String getJenkinsUrlOrNull() {
        Object url = this.getJenkinsUrl();
        if (!(url != null || this.isWebSocket() && this.getCredentialsId() != null)) {
            url = Util.fixEmpty((String)System.getProperty("KUBERNETES_JENKINS_URL", System.getenv("KUBERNETES_JENKINS_URL")));
        }
        if (url == null) {
            url = JenkinsLocationConfiguration.get().getUrl();
        }
        if (url == null) {
            return null;
        }
        url = ((String)url).endsWith("/") ? url : (String)url + "/";
        return url;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    @DataBoundSetter
    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    public boolean isDirectConnection() {
        return this.directConnection;
    }

    @DataBoundSetter
    public void setDirectConnection(boolean directConnection) {
        this.directConnection = directConnection;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = Util.fixEmptyAndTrim((String)jenkinsUrl);
    }

    public String getJenkinsTunnel() {
        return this.jenkinsTunnel;
    }

    @DataBoundSetter
    public void setJenkinsTunnel(String jenkinsTunnel) {
        this.jenkinsTunnel = Util.fixEmpty((String)jenkinsTunnel);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public int getContainerCap() {
        return this.containerCap != null ? this.containerCap : Integer.MAX_VALUE;
    }

    @DataBoundSetter
    public void setContainerCapStr(String containerCapStr) {
        this.setContainerCap(containerCapStr.equals("") ? null : Integer.valueOf(Integer.parseInt(containerCapStr)));
    }

    public void setContainerCap(Integer containerCap) {
        this.containerCap = containerCap != null && containerCap > 0 ? containerCap : null;
    }

    public String getContainerCapStr() {
        return this.containerCap == null || this.containerCap == Integer.MAX_VALUE || this.containerCap == 0 ? "" : String.valueOf(this.containerCap);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Math.max(15, readTimeout);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public Map<String, String> getLabels() {
        return this.getPodLabelsMap();
    }

    @Deprecated
    public void setLabels(Map<String, String> labels) {
        this.setPodLabels(labels != null ? PodLabel.fromMap(labels) : Collections.emptyList());
    }

    @NonNull
    public List<PodLabel> getPodLabels() {
        return this.podLabels == null || this.podLabels.isEmpty() ? PodLabel.fromMap(DEFAULT_POD_LABELS) : this.podLabels;
    }

    @DataBoundSetter
    public void setPodLabels(@CheckForNull List<PodLabel> labels) {
        this.podLabels = new ArrayList<PodLabel>();
        if (labels != null) {
            this.podLabels.addAll(labels);
        }
    }

    Map<String, String> getPodLabelsMap() {
        return PodLabel.toMap(this.getPodLabels());
    }

    @DataBoundSetter
    public void setMaxRequestsPerHostStr(String maxRequestsPerHostStr) {
        try {
            this.setMaxRequestsPerHost(Integer.parseInt(maxRequestsPerHostStr));
        }
        catch (NumberFormatException e) {
            this.setMaxRequestsPerHost(32);
        }
    }

    @DataBoundSetter
    public void setMaxRequestsPerHost(int maxRequestsPerHost) {
        this.maxRequestsPerHost = maxRequestsPerHost < 0 ? 32 : maxRequestsPerHost;
    }

    public String getMaxRequestsPerHostStr() {
        return String.valueOf(this.maxRequestsPerHost);
    }

    public int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    @DataBoundSetter
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = Math.max(5, connectTimeout);
    }

    public PodRetention getPodRetention() {
        return this.podRetention;
    }

    @DataBoundSetter
    public void setPodRetention(PodRetention podRetention) {
        if (podRetention == null || podRetention instanceof Default) {
            podRetention = PodRetention.getKubernetesCloudDefault();
        }
        this.podRetention = podRetention;
    }

    public KubernetesClient connect() throws KubernetesAuthException, IOException {
        LOGGER.log(Level.FINEST, "Building connection to Kubernetes {0} URL {1} namespace {2}", new String[]{this.getDisplayName(), this.serverUrl, this.namespace});
        KubernetesClient client = null;
        try {
            client = KubernetesClientProvider.createClient(this);
        }
        catch (KubernetesAuthException e) {
            KubernetesClientProvider.invalidate(this.getDisplayName());
            client = KubernetesClientProvider.createClient(this);
        }
        LOGGER.log(Level.FINE, "Connected to Kubernetes {0} URL {1} namespace {2}", new String[]{this.getDisplayName(), client.getMasterUrl().toString(), this.namespace});
        return client;
    }

    @NonNull
    public PodResource getPodResource(@Nullable String namespace, @NonNull String name) throws KubernetesAuthException, IOException {
        return KubernetesCloud.getPodResource(this.connect(), namespace, name);
    }

    @NonNull
    static PodResource getPodResource(@NonNull KubernetesClient client, @Nullable String namespace, @NonNull String name) {
        if (namespace == null) {
            return (PodResource)client.pods().withName(name);
        }
        return (PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(name);
    }

    public Collection<NodeProvisioner.PlannedNode> provision(@NonNull Cloud.CloudState state, int excessWorkload) {
        LimitRegistrationResults limitRegistrationResults = new LimitRegistrationResults(this);
        try {
            Label label = state.getLabel();
            int plannedCapacity = state.getAdditionalPlannedCapacity();
            Set<String> allInProvisioning = InProvisioning.getAllInProvisioning(label);
            LOGGER.log(Level.FINE, () -> "In provisioning : " + String.valueOf(allInProvisioning));
            int toBeProvisioned = Math.max(0, excessWorkload - allInProvisioning.size());
            ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
            LOGGER.log(Level.FINE, "Label \"{0}\" excess workload: {1}, executors: {2}", new Object[]{label, toBeProvisioned, plannedCapacity});
            for (PodTemplate podTemplate : this.getTemplatesFor(label)) {
                LOGGER.log(Level.FINE, "Template for label \"{0}\": {1}", new Object[]{label, podTemplate.getName()});
                int numExecutors = 1;
                PodTemplate unwrappedTemplate = this.getUnwrappedTemplate(podTemplate);
                while (toBeProvisioned > 0 && limitRegistrationResults.register(podTemplate, numExecutors)) {
                    plannedNodes.add(PlannedNodeBuilderFactory.createInstance().cloud(this).template(unwrappedTemplate).label(label).numExecutors(1).build());
                    --toBeProvisioned;
                }
                if (plannedNodes.isEmpty()) continue;
                LOGGER.log(Level.FINEST, "Planned {0} Kubernetes agents with template \"{1}\"", new Object[]{plannedNodes.size(), podTemplate.getName()});
                Metrics.metricRegistry().counter("kubernetes.cloud.provision.nodes").inc((long)plannedNodes.size());
                return plannedNodes;
            }
            Metrics.metricRegistry().counter("kubernetes.cloud.provision.nodes").inc((long)plannedNodes.size());
            return plannedNodes;
        }
        catch (KubernetesClientException e) {
            Metrics.metricRegistry().counter("kubernetes.cloud.provision.failed").inc();
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException || cause instanceof ConnectException || cause instanceof UnknownHostException) {
                LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}: {1}", new String[]{this.serverUrl, cause.getMessage()});
            } else {
                LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", cause != null ? cause : e);
            }
            limitRegistrationResults.unregister();
        }
        catch (Exception e) {
            Metrics.metricRegistry().counter("kubernetes.cloud.provision.failed").inc();
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", e);
            limitRegistrationResults.unregister();
        }
        return Collections.emptyList();
    }

    private static void ensureKubernetesUrlInFipsMode(String url) {
        if (!FIPS140.useCompliantAlgorithms() || StringUtils.isBlank((String)url)) {
            return;
        }
        if (!url.startsWith("https:")) {
            throw new IllegalArgumentException(Messages.KubernetesCloud_kubernetesServerUrlIsNotSecure());
        }
    }

    private static void ensureSkipTlsVerifyInFipsMode(boolean skipTlsVerify) {
        if (FIPS140.useCompliantAlgorithms() && skipTlsVerify) {
            throw new IllegalArgumentException(Messages.KubernetesCloud_skipTlsVerifyNotAllowedInFIPSMode());
        }
    }

    private static void ensureServerCertificateInFipsMode(String serverCertificate) {
        if (!FIPS140.useCompliantAlgorithms()) {
            return;
        }
        if (StringUtils.isBlank((String)serverCertificate)) {
            return;
        }
        try {
            PEMEncodable pem = PEMEncodable.decode((String)serverCertificate);
            Certificate cert = pem.toCertificate();
            if (cert == null) {
                throw new IllegalArgumentException(Messages.KubernetesCloud_serverCertificateNotACertificate());
            }
            PublicKey publicKey = cert.getPublicKey();
            if (publicKey instanceof RSAPublicKey) {
                if (((RSAPublicKey)publicKey).getModulus().bitLength() < 2048) {
                    throw new IllegalArgumentException(Messages.KubernetesCloud_serverCertificateKeySize());
                }
            } else if (publicKey instanceof DSAPublicKey) {
                if (((DSAPublicKey)publicKey).getParams().getP().bitLength() < 2048) {
                    throw new IllegalArgumentException(Messages.KubernetesCloud_serverCertificateKeySize());
                }
            } else if (publicKey instanceof ECPublicKey && ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize() < 224) {
                throw new IllegalArgumentException(Messages.KubernetesCloud_serverCertificateKeySizeEC());
            }
        }
        catch (IOException | RuntimeException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public void replaceTemplate(PodTemplate oldTemplate, PodTemplate newTemplate) {
        this.checkManagePermission();
        this.removeTemplate(oldTemplate);
        this.addTemplate(newTemplate);
    }

    @Override
    public Permission getManagePermission() {
        return Jenkins.MANAGE;
    }

    public boolean canProvision(@NonNull Cloud.CloudState state) {
        return this.getTemplate(state.getLabel()) != null;
    }

    @CheckForNull
    public PodTemplate getTemplate(@CheckForNull Label label) {
        return PodTemplateUtils.getTemplateByLabel(label, this.getAllTemplates());
    }

    @CheckForNull
    public PodTemplate getTemplate(@NonNull String id) {
        return this.getTemplateById(id);
    }

    @CheckForNull
    public PodTemplate getTemplateById(@NonNull String id) {
        return this.getAllTemplates().stream().filter(t -> id.equals(t.getId())).findFirst().orElse(null);
    }

    public PodTemplate getUnwrappedTemplate(PodTemplate podTemplate) {
        return PodTemplateUtils.unwrap(podTemplate, this.getDefaultsProviderTemplate(), this.getAllTemplates());
    }

    @Deprecated
    public ArrayList<PodTemplate> getMatchingTemplates(@CheckForNull Label label) {
        return new ArrayList<PodTemplate>(this.getTemplatesFor(label));
    }

    public List<PodTemplate> getTemplatesFor(@CheckForNull Label label) {
        return PodTemplateFilter.applyAll(this, this.getAllTemplates(), label);
    }

    @Override
    public void addTemplate(PodTemplate t) {
        this.checkManagePermission();
        this.templates.add(t);
    }

    @Override
    public void removeTemplate(PodTemplate t) {
        this.checkManagePermission();
        this.templates.remove(t);
    }

    @Override
    public String getPodTemplateGroupUrl() {
        return "../../templates";
    }

    public void addDynamicTemplate(PodTemplate t) {
        PodTemplateMap.get().addTemplate(this, t);
    }

    public void removeDynamicTemplate(PodTemplate t) {
        PodTemplateMap.get().removeTemplate(this, t);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesCloud that = (KubernetesCloud)o;
        return Objects.equals(this.name, that.name) && this.skipTlsVerify == that.skipTlsVerify && this.addMasterProxyEnvVars == that.addMasterProxyEnvVars && this.capOnlyOnAlivePods == that.capOnlyOnAlivePods && Objects.equals(this.containerCap, that.containerCap) && this.retentionTimeout == that.retentionTimeout && this.connectTimeout == that.connectTimeout && this.readTimeout == that.readTimeout && this.usageRestricted == that.usageRestricted && this.maxRequestsPerHost == that.maxRequestsPerHost && Objects.equals(this.defaultsProviderTemplate, that.defaultsProviderTemplate) && this.templates.equals(that.templates) && Objects.equals(this.serverUrl, that.serverUrl) && Objects.equals(this.serverCertificate, that.serverCertificate) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.jnlpregistry, that.jnlpregistry) && Objects.equals(this.jenkinsUrl, that.jenkinsUrl) && Objects.equals(this.jenkinsTunnel, that.jenkinsTunnel) && Objects.equals(this.credentialsId, that.credentialsId) && Objects.equals(this.getPodLabels(), that.getPodLabels()) && Objects.equals((Object)this.podRetention, (Object)that.podRetention) && Objects.equals(this.waitForPodSec, that.waitForPodSec) && Objects.equals((Object)this.garbageCollection, (Object)that.garbageCollection) && this.useJenkinsProxy == that.useJenkinsProxy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.defaultsProviderTemplate, this.templates, this.serverUrl, this.serverCertificate, this.skipTlsVerify, this.addMasterProxyEnvVars, this.capOnlyOnAlivePods, this.namespace, this.jnlpregistry, this.jenkinsUrl, this.jenkinsTunnel, this.credentialsId, this.containerCap, this.retentionTimeout, this.connectTimeout, this.readTimeout, this.podLabels, this.usageRestricted, this.maxRequestsPerHost, this.podRetention, this.useJenkinsProxy, this.garbageCollection});
    }

    public Integer getWaitForPodSec() {
        return this.waitForPodSec;
    }

    @DataBoundSetter
    public void setWaitForPodSec(Integer waitForPodSec) {
        this.waitForPodSec = waitForPodSec;
    }

    @Restricted(value={NoExternalUse.class})
    public PodTemplate.DescriptorImpl getTemplateDescriptor() {
        return (PodTemplate.DescriptorImpl)Jenkins.get().getDescriptorOrDie(PodTemplate.class);
    }

    @POST
    public HttpResponse doCreate(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        Jenkins j = Jenkins.get();
        this.checkManagePermission();
        PodTemplate newTemplate = (PodTemplate)this.getTemplateDescriptor().newInstance(req, req.getSubmittedForm());
        this.addTemplate(newTemplate);
        j.save();
        return FormApply.success((String)"templates");
    }

    public String toString() {
        return "KubernetesCloud{name=" + this.name + ", defaultsProviderTemplate='" + this.defaultsProviderTemplate + "', serverUrl='" + this.serverUrl + "', serverCertificate='" + this.serverCertificate + "', skipTlsVerify=" + this.skipTlsVerify + ", addMasterProxyEnvVars=" + this.addMasterProxyEnvVars + ", capOnlyOnAlivePods=" + this.capOnlyOnAlivePods + ", namespace='" + this.namespace + "', jnlpregistry='" + this.jnlpregistry + "', jenkinsUrl='" + this.jenkinsUrl + "', jenkinsTunnel='" + this.jenkinsTunnel + "', credentialsId='" + this.credentialsId + "', webSocket=" + this.webSocket + ", containerCap=" + this.containerCap + ", retentionTimeout=" + this.retentionTimeout + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", labels=" + String.valueOf(this.labels) + ", podLabels=" + String.valueOf(this.podLabels) + ", usageRestricted=" + this.usageRestricted + ", maxRequestsPerHost=" + this.maxRequestsPerHost + ", waitForPodSec=" + this.waitForPodSec + ", podRetention=" + String.valueOf((Object)this.podRetention) + ", useJenkinsProxy=" + this.useJenkinsProxy + ", templates=" + String.valueOf(this.templates) + ", garbageCollection=" + String.valueOf((Object)this.garbageCollection) + "}";
    }

    private Object readResolve() {
        if (this.serverCertificate != null && !this.serverCertificate.trim().startsWith("-----BEGIN CERTIFICATE-----")) {
            this.serverCertificate = new String(Base64.getDecoder().decode(this.serverCertificate.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            LOGGER.log(Level.INFO, "Upgraded Kubernetes server certificate key: {0}", this.serverCertificate.substring(0, 80));
        }
        KubernetesCloud.ensureServerCertificateInFipsMode(this.serverCertificate);
        KubernetesCloud.ensureKubernetesUrlInFipsMode(this.serverUrl);
        KubernetesCloud.ensureSkipTlsVerifyInFipsMode(this.skipTlsVerify);
        if (this.maxRequestsPerHost == 0) {
            this.maxRequestsPerHost = 32;
        }
        if (this.podRetention == null) {
            this.podRetention = PodRetention.getKubernetesCloudDefault();
        }
        this.setConnectTimeout(this.connectTimeout);
        this.setReadTimeout(this.readTimeout);
        this.setRetentionTimeout(this.retentionTimeout);
        if (this.waitForPodSec == null) {
            this.waitForPodSec = DEFAULT_WAIT_FOR_POD_SEC;
        }
        if (this.podLabels == null && this.labels != null) {
            this.setPodLabels(PodLabel.fromMap(this.labels));
        }
        if (this.containerCap != null && this.containerCap == 0) {
            this.containerCap = null;
        }
        return this;
    }

    public Cloud reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        KubernetesCloud newInstance = (KubernetesCloud)super.reconfigure(req, form);
        newInstance.setTemplates(this.templates);
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPodInformer(KubernetesSlave node) {
        if (this.informers == null) {
            KubernetesCloud kubernetesCloud = this;
            synchronized (kubernetesCloud) {
                if (this.informers == null) {
                    this.informers = new ConcurrentHashMap<String, SharedIndexInformer<Pod>>();
                }
            }
        }
        this.informers.computeIfAbsent(node.getNamespace(), n -> {
            KubernetesClient client;
            try {
                client = this.connect();
            }
            catch (IOException | KubernetesAuthException e) {
                LOGGER.log(Level.WARNING, "Cannot connect to K8s cloud. Pod events will not be available in build logs.", e);
                return null;
            }
            HashMap<String, String> labelsFilter = new HashMap<String, String>(this.getPodLabelsMap());
            String jenkinsUrlLabel = PodTemplateUtils.sanitizeLabel(this.getJenkinsUrlOrNull());
            if (jenkinsUrlLabel != null) {
                labelsFilter.put("kubernetes.jenkins.io/controller", jenkinsUrlLabel);
            }
            SharedIndexInformer inform = ((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(node.getNamespace())).withLabels(labelsFilter)).inform((ResourceEventHandler)new PodStatusEventHandler(), TimeUnit.SECONDS.toMillis(30L));
            LOGGER.info(String.format("Registered informer to watch pod events on namespace [%s], with labels [%s] on cloud [%s]", this.namespace, labelsFilter, this.name));
            return inform;
        });
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_LOADED)
    public static void hpiRunInit() {
        if (Main.isDevelopmentMode) {
            Jenkins jenkins = Jenkins.get();
            String hostAddress = System.getProperty("jenkins.host.address");
            if (hostAddress != null && jenkins.clouds.getAll(KubernetesCloud.class).isEmpty()) {
                KubernetesCloud cloud = new KubernetesCloud("kubernetes");
                cloud.setJenkinsUrl("http://" + hostAddress + ":" + SystemProperties.getInteger((String)"port", (Integer)8080) + "/jenkins/");
                jenkins.clouds.add((Object)cloud);
            }
        }
    }

    @Extension
    public static class PodTemplateSourceImpl
    extends PodTemplateSource {
        @Override
        @NonNull
        public List<PodTemplate> getList(@NonNull KubernetesCloud cloud) {
            return cloud.getTemplates();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Kubernetes";
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.OpenShiftBearerTokenCredentialImpl", OpenShiftBearerTokenCredentialImpl.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.OpenShiftTokenCredentialImpl", StringCredentialsImpl.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.ServiceAccountCredential", FileSystemServiceAccountCredential.class);
        }

        @RequirePOST
        public FormValidation doTestConnection(@AncestorInPath ItemGroup owner, @QueryParameter String name, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String serverCertificate, @QueryParameter boolean skipTlsVerify, @QueryParameter String namespace, @QueryParameter int connectionTimeout, @QueryParameter int readTimeout, @QueryParameter boolean useJenkinsProxy) {
            FormValidation formValidation;
            block10: {
                Jenkins _context = owner instanceof AccessControlled ? (AccessControlled)owner : Jenkins.get();
                DescriptorImpl.checkPermission((AccessControlled)_context);
                if (StringUtils.isBlank((String)name)) {
                    return FormValidation.error((String)"name is required");
                }
                KubernetesClient client = new KubernetesFactoryAdapter(serverUrl, namespace, Util.fixEmpty((String)serverCertificate), Util.fixEmpty((String)credentialsId), owner, skipTlsVerify, connectionTimeout, readTimeout, 32, useJenkinsProxy).createClient();
                try {
                    client.pods().list();
                    VersionInfo version = client.getVersion();
                    formValidation = FormValidation.ok((String)("Connected to Kubernetes " + version.getGitVersion()));
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (KubernetesClientException e) {
                        LOGGER.log(Level.FINE, String.format("Error testing connection %s", serverUrl), e);
                        return FormValidation.error((String)"Error testing connection %s: %s", (Object[])new Object[]{serverUrl, e.getCause() == null ? e.getMessage() : String.format("%s: %s", e.getCause().getClass().getName(), e.getCause().getMessage())});
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, String.format("Error testing connection %s", serverUrl), e);
                        return FormValidation.error((String)"Error testing connection %s: %s", (Object[])new Object[]{serverUrl, e.getMessage()});
                    }
                }
                client.close();
            }
            return formValidation;
        }

        @RequirePOST
        public FormValidation doCheckSkipTlsVerify(@AncestorInPath AccessControlled owner, @QueryParameter boolean skipTlsVerify) {
            if (!DescriptorImpl.hasPermission(owner)) {
                return FormValidation.ok();
            }
            try {
                KubernetesCloud.ensureSkipTlsVerifyInFipsMode(skipTlsVerify);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckServerCertificate(@AncestorInPath AccessControlled owner, @QueryParameter String serverCertificate) {
            if (!DescriptorImpl.hasPermission(owner)) {
                return FormValidation.ok();
            }
            try {
                KubernetesCloud.ensureServerCertificateInFipsMode(serverCertificate);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckServerUrl(@AncestorInPath AccessControlled owner, @QueryParameter String serverUrl) {
            if (!DescriptorImpl.hasPermission(owner)) {
                return FormValidation.ok();
            }
            try {
                KubernetesCloud.ensureKubernetesUrlInFipsMode(serverUrl);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((String)ex.getLocalizedMessage());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup owner, @QueryParameter String serverUrl) {
            DescriptorImpl.checkPermission((AccessControlled)(owner instanceof AccessControlled ? (AccessControlled)owner : Jenkins.get()));
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeEmptyValue();
            result.includeMatchingAs(ACL.SYSTEM, owner, StandardCredentials.class, serverUrl != null ? URIRequirementBuilder.fromUri((String)serverUrl).build() : Collections.EMPTY_LIST, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(KubernetesAuth.class)}));
            return result;
        }

        @RequirePOST
        public FormValidation doCheckMaxRequestsPerHostStr(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validatePositiveInteger((String)value);
        }

        @RequirePOST
        public FormValidation doCheckConnectTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)5, (int)Integer.MAX_VALUE);
        }

        @RequirePOST
        public FormValidation doCheckReadTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)15, (int)Integer.MAX_VALUE);
        }

        @RequirePOST
        public FormValidation doCheckRetentionTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)5, (int)Integer.MAX_VALUE);
        }

        @RequirePOST
        public FormValidation doCheckDirectConnection(@AncestorInPath AccessControlled owner, @QueryParameter boolean value, @QueryParameter String jenkinsUrl, @QueryParameter boolean webSocket) {
            if (!DescriptorImpl.hasPermission(owner)) {
                return FormValidation.ok();
            }
            if (!webSocket) {
                TcpSlaveAgentListener tcpSlaveAgentListener = Jenkins.get().getTcpSlaveAgentListener();
                if (tcpSlaveAgentListener == null) {
                    return FormValidation.warning((String)"'TCP port for inbound agents' is disabled in Global Security settings. Connecting Kubernetes agents will not work without this or WebSocket mode!");
                }
                if (tcpSlaveAgentListener.getIdentityPublicKey() == null) {
                    return FormValidation.error((String)"You must install the instance-identity plugin to use inbound agents in TCP mode");
                }
            }
            if (value) {
                if (webSocket) {
                    return FormValidation.error((String)"Direct connection and WebSocket mode are mutually exclusive");
                }
                if (!StringUtils.isEmpty((String)jenkinsUrl)) {
                    return FormValidation.warning((String)"No need to configure Jenkins URL when direct connection is enabled");
                }
                if (Jenkins.get().getSlaveAgentPort() == 0) {
                    return FormValidation.warning((String)"A random 'TCP port for inbound agents' is configured in Global Security settings. In 'direct connection' mode agents will not be able to reconnect to a restarted controller with random port!");
                }
            } else if (StringUtils.isEmpty((String)jenkinsUrl)) {
                String url = StringUtils.defaultIfBlank((String)System.getProperty("KUBERNETES_JENKINS_URL", System.getenv("KUBERNETES_JENKINS_URL")), (String)JenkinsLocationConfiguration.get().getUrl());
                if (url != null) {
                    return FormValidation.ok((String)("Will connect using " + url));
                }
                return FormValidation.warning((String)"Configure either Direct Connection or Jenkins URL");
            }
            return FormValidation.ok();
        }

        private static boolean hasPermission(AccessControlled owner) {
            if (owner instanceof Jenkins) {
                return owner.hasPermission(Jenkins.ADMINISTER);
            }
            if (owner instanceof Item) {
                return owner.hasPermission(Item.CONFIGURE);
            }
            LOGGER.log(Level.WARNING, () -> "Unsupported owner type " + String.valueOf(owner == null ? "null" : owner.getClass()) + " (url: " + Stapler.getCurrentRequest2().getOriginalRequestURI() + "). Please report this issue to the plugin maintainers.");
            return false;
        }

        private static void checkPermission(AccessControlled owner) {
            if (owner instanceof Jenkins) {
                owner.checkPermission(Jenkins.ADMINISTER);
            } else if (owner instanceof Item) {
                owner.checkPermission(Item.CONFIGURE);
            } else {
                throw new IllegalArgumentException("Unsupported owner type " + String.valueOf(owner == null ? "null" : owner.getClass()) + " (url: " + Stapler.getCurrentRequest2().getOriginalRequestURI() + "). Please report this issue to the plugin maintainers.");
            }
        }

        public FormValidation doCheckJenkinsUrl(@QueryParameter String value, @QueryParameter boolean directConnection) throws IOException, ServletException {
            try {
                if (!StringUtils.isEmpty((String)value)) {
                    new URL(value);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)"Invalid Jenkins URL");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckWebSocket(@AncestorInPath AccessControlled owner, @QueryParameter boolean webSocket, @QueryParameter boolean directConnection, @QueryParameter String jenkinsTunnel) {
            if (!DescriptorImpl.hasPermission(owner)) {
                return FormValidation.ok();
            }
            if (webSocket) {
                if (!WebSockets.isSupported()) {
                    return FormValidation.error((String)"WebSocket support is not enabled in this Jenkins installation");
                }
                if (Util.fixEmpty((String)jenkinsTunnel) != null) {
                    return FormValidation.error((String)"Tunneling is not currently supported in WebSocket mode");
                }
            }
            return FormValidation.ok();
        }

        public List<Descriptor<PodRetention>> getAllowedPodRetentions() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor<PodRetention>>(0);
            }
            return DescriptorVisibilityFilter.apply((Object)((Object)this), (Iterable)jenkins.getDescriptorList(PodRetention.class));
        }

        public Descriptor getDefaultPodRetention() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return null;
            }
            return jenkins.getDescriptor(((Object)((Object)PodRetention.getKubernetesCloudDefault())).getClass());
        }

        public int getDefaultReadTimeout() {
            return 15;
        }

        public int getDefaultConnectTimeout() {
            return 5;
        }

        public int getDefaultRetentionTimeout() {
            return 5;
        }

        public int getDefaultWaitForPod() {
            return DEFAULT_WAIT_FOR_POD_SEC;
        }

        public List<? extends KubernetesCloudTraitDescriptor> getAllTraits() {
            return KubernetesCloudTrait.all();
        }

        public DescribableList<KubernetesCloudTrait, KubernetesCloudTraitDescriptor> getDefaultTraits() {
            return new DescribableList(Saveable.NOOP, KubernetesCloudTrait.getDefaultTraits());
        }
    }
}

